"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReadKnowledgeBaseResponse = exports.ReadKnowledgeBaseRequestParams = exports.PostKnowledgeBaseResponse = exports.PostKnowledgeBaseRequestQuery = exports.KnowledgeBaseResponse400 = exports.KnowledgeBaseResponse = exports.KnowledgeBaseReadResponse200 = exports.GetKnowledgeBaseResponse = exports.CreateKnowledgeBaseResponse = exports.CreateKnowledgeBaseRequestQuery = exports.CreateKnowledgeBaseRequestParams = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: KnowledgeBase API endpoints
 *   version: 2023-10-31
 */

/**
 * AI assistant KnowledgeBase.
 */

const KnowledgeBaseResponse = exports.KnowledgeBaseResponse = _zod.z.object({
  /**
   * Identify the success of the method execution.
   */
  success: _zod.z.boolean().optional()
});
const KnowledgeBaseResponse400 = exports.KnowledgeBaseResponse400 = _zod.z.object({
  /**
   * The HTTP status code of the error.
   */
  statusCode: _zod.z.number().optional(),
  /**
   * A short description of the error.
   */
  error: _zod.z.string().optional(),
  /**
   * A detailed error message.
   */
  message: _zod.z.string().optional()
});
const KnowledgeBaseReadResponse200 = exports.KnowledgeBaseReadResponse200 = _zod.z.object({
  /**
   * Indicates if the ELSER model exists for the KnowledgeBase.
   */
  elser_exists: _zod.z.boolean().optional(),
  /**
   * Indicates if the setup process is available for the KnowledgeBase.
   */
  is_setup_available: _zod.z.boolean().optional(),
  /**
   * Indicates if the setup process is currently in progress.
   */
  is_setup_in_progress: _zod.z.boolean().optional(),
  /**
   * Indicates if Security Labs documentation exists in the KnowledgeBase.
   */
  security_labs_exists: _zod.z.boolean().optional(),
  /**
   * Indicates if Defend Insights documentation exists in the KnowledgeBase.
   */
  defend_insights_exists: _zod.z.boolean().optional(),
  /**
   * Indicates if user data exists in the KnowledgeBase.
   */
  user_data_exists: _zod.z.boolean().optional(),
  /**
   * The status of the product documentation in the KnowledgeBase.
   */
  product_documentation_status: _zod.z.string().optional()
});
const CreateKnowledgeBaseRequestQuery = exports.CreateKnowledgeBaseRequestQuery = _zod.z.object({
  /**
   * ELSER modelId to use when setting up the Knowledge Base. If not provided, a default model will be used.
   */
  modelId: _zod.z.string().optional(),
  /**
   * Indicates whether we should or should not install Security Labs docs when setting up the Knowledge Base. Defaults to `false`.
   */
  ignoreSecurityLabs: _zodHelpers.BooleanFromString.optional().default(false)
});
const CreateKnowledgeBaseRequestParams = exports.CreateKnowledgeBaseRequestParams = _zod.z.object({
  /**
   * The KnowledgeBase `resource` value.
   */
  resource: _zod.z.string()
});
const CreateKnowledgeBaseResponse = exports.CreateKnowledgeBaseResponse = KnowledgeBaseResponse;
const GetKnowledgeBaseResponse = exports.GetKnowledgeBaseResponse = KnowledgeBaseReadResponse200;
const PostKnowledgeBaseRequestQuery = exports.PostKnowledgeBaseRequestQuery = _zod.z.object({
  /**
   * ELSER modelId to use when setting up the Knowledge Base. If not provided, a default model will be used.
   */
  modelId: _zod.z.string().optional(),
  /**
   * Indicates whether we should or should not install Security Labs docs when setting up the Knowledge Base. Defaults to `false`.
   */
  ignoreSecurityLabs: _zodHelpers.BooleanFromString.optional().default(false)
});
const PostKnowledgeBaseResponse = exports.PostKnowledgeBaseResponse = KnowledgeBaseResponse;
const ReadKnowledgeBaseRequestParams = exports.ReadKnowledgeBaseRequestParams = _zod.z.object({
  /**
   * The KnowledgeBase `resource` value.
   */
  resource: _zod.z.string()
});
const ReadKnowledgeBaseResponse = exports.ReadKnowledgeBaseResponse = KnowledgeBaseReadResponse200;