"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetSuccessfulGenerationsSearchResult = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GetSuccessfulGenerationsSearchResult = exports.GetSuccessfulGenerationsSearchResult = _zod.z.object({
  aggregations: _zod.z.object({
    successfull_generations_by_connector_id: _zod.z.object({
      buckets: _zod.z.array(_zod.z.object({
        key: _zod.z.string(),
        // Connector ID
        doc_count: _zod.z.number(),
        // Total document count for this connector
        event_actions: _zod.z.object({
          buckets: _zod.z.array(_zod.z.object({
            key: _zod.z.string(),
            // Event action (e.g., "generation-succeeded")
            doc_count: _zod.z.number() // Count of this event action
          }))
        }),
        successful_generations: _zod.z.object({
          value: _zod.z.number() // Count of successful generations
        }),
        avg_event_duration_nanoseconds: _zod.z.object({
          value: _zod.z.number().nullable() // Average event duration in nanoseconds
        }),
        latest_successfull_generation: _zod.z.object({
          value: _zod.z.number().nullable(),
          // Latest successful generation timestamp (epoch)
          value_as_string: _zod.z.string().nullable() // Latest successful generation timestamp (ISO string)
        })
      }))
    })
  })
});