"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnonymizedEventsRetriever = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _retrievers = require("@langchain/core/retrievers");
var _get_events = require("./get_events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AnonymizedEventsRetriever extends _retrievers.BaseRetriever {
  constructor({
    insightType,
    endpointIds,
    anonymizationFields,
    fields,
    esClient,
    kbDataClient,
    onNewReplacements,
    replacements,
    size,
    start,
    end
  }) {
    super(fields);
    (0, _defineProperty2.default)(this, "lc_namespace", ['langchain', 'retrievers']);
    (0, _defineProperty2.default)(this, "insightType", void 0);
    (0, _defineProperty2.default)(this, "endpointIds", void 0);
    (0, _defineProperty2.default)(this, "anonymizationFields", void 0);
    (0, _defineProperty2.default)(this, "esClient", void 0);
    (0, _defineProperty2.default)(this, "kbDataClient", void 0);
    (0, _defineProperty2.default)(this, "onNewReplacements", void 0);
    (0, _defineProperty2.default)(this, "replacements", void 0);
    (0, _defineProperty2.default)(this, "size", void 0);
    (0, _defineProperty2.default)(this, "start", void 0);
    (0, _defineProperty2.default)(this, "end", void 0);
    this.insightType = insightType;
    this.endpointIds = endpointIds;
    this.anonymizationFields = anonymizationFields;
    this.esClient = esClient;
    this.kbDataClient = kbDataClient;
    this.onNewReplacements = onNewReplacements;
    this.replacements = replacements;
    this.size = size;
    this.start = start;
    this.end = end;
  }
  async _getRelevantDocuments(query, runManager) {
    const anonymizedEvents = await (0, _get_events.getAnonymizedEvents)({
      insightType: this.insightType,
      endpointIds: this.endpointIds,
      anonymizationFields: this.anonymizationFields,
      esClient: this.esClient,
      kbDataClient: this.kbDataClient,
      onNewReplacements: this.onNewReplacements,
      replacements: this.replacements,
      size: this.size,
      start: this.start,
      end: this.end
    });
    return anonymizedEvents.map(event => ({
      pageContent: event,
      metadata: {}
    }));
  }
}
exports.AnonymizedEventsRetriever = AnonymizedEventsRetriever;