"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.discardPreviousRefinements = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const discardPreviousRefinements = ({
  generationAttempts,
  hallucinationFailures,
  isHallucinationDetected,
  state
}) => {
  return {
    ...state,
    combinedRefinements: '',
    // <-- reset the combined refinements
    generationAttempts: generationAttempts + 1,
    refinements: [],
    // <-- reset the refinements
    hallucinationFailures: isHallucinationDetected ? hallucinationFailures + 1 : hallucinationFailures
  };
};
exports.discardPreviousRefinements = discardPreviousRefinements;