"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.enrichConversation = void 0;
var _messages = require("@langchain/core/messages");
var _local_prompt_object = require("../../prompt/local_prompt_object");
var _prompt = require("../../prompt");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Apply enrichments to a conversation
 */
const enrichConversation = params => {
  const userPromptEnricher = getUserPrompt(params);
  return userPromptEnricher(params.messages);
};

/**
 * Prepends the user prompt to the last message if the last message is a human message.
 */
exports.enrichConversation = enrichConversation;
const getUserPrompt = params => {
  return async messages => {
    const userPrompt = params.llmType === 'gemini' ? await (0, _prompt.getPrompt)({
      actionsClient: params.actionsClient,
      connectorId: params.connectorId,
      promptId: _prompt.promptDictionary.userPrompt,
      promptGroupId: _local_prompt_object.promptGroupId.aiAssistant,
      provider: 'gemini',
      savedObjectsClient: params.savedObjectsClient
    }) : '';
    if (!userPrompt || messages.length < 1) {
      return messages;
    }
    const messagesCopy = [...messages]; // Create a copy to avoid mutating the original messages
    const lastMessage = messagesCopy[messagesCopy.length - 1];
    if (lastMessage instanceof _messages.HumanMessage) {
      messagesCopy[messagesCopy.length - 1] = new _messages.HumanMessage(`${userPrompt} ${lastMessage.content}`.trim(), lastMessage.additional_kwargs);
    }
    return messagesCopy;
  };
};