"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateAttackDiscoveries = void 0;
var _invoke_attack_discovery_graph = require("../public/post/helpers/invoke_attack_discovery_graph");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ROUTE_HANDLER_TIMEOUT = 10 * 60 * 1000; // 10 * 60 seconds = 10 minutes
const LANG_CHAIN_TIMEOUT = ROUTE_HANDLER_TIMEOUT - 10_000; // 9 minutes 50 seconds
const CONNECTOR_TIMEOUT = LANG_CHAIN_TIMEOUT - 10_000; // 9 minutes 40 seconds

const generateAttackDiscoveries = async ({
  actionsClient,
  config,
  esClient,
  logger,
  savedObjectsClient
}) => {
  // get parameters from the request body
  const alertsIndexPattern = decodeURIComponent(config.alertsIndexPattern);
  const {
    apiConfig,
    anonymizationFields,
    end,
    filter,
    langSmithApiKey,
    langSmithProject,
    replacements,
    size,
    start
  } = config;

  // callback to accumulate the latest replacements:
  let latestReplacements = {
    ...replacements
  };
  const onNewReplacements = newReplacements => {
    latestReplacements = {
      ...latestReplacements,
      ...newReplacements
    };
  };
  const {
    anonymizedAlerts,
    attackDiscoveries
  } = await (0, _invoke_attack_discovery_graph.invokeAttackDiscoveryGraph)({
    actionsClient,
    alertsIndexPattern,
    anonymizationFields,
    apiConfig,
    connectorTimeout: CONNECTOR_TIMEOUT,
    end,
    esClient,
    filter,
    langSmithProject,
    langSmithApiKey,
    latestReplacements,
    logger,
    onNewReplacements,
    savedObjectsClient,
    size,
    start
  });
  return {
    anonymizedAlerts,
    attackDiscoveries,
    replacements: latestReplacements
  };
};
exports.generateAttackDiscoveries = generateAttackDiscoveries;