"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigEditorContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _alerts_filters_form = require("@kbn/response-ops-alerts-filters-form/components/alerts_filters_form");
var _alerts_solution_selector = require("@kbn/response-ops-alerts-filters-form/components/alerts_solution_selector");
var _filters = require("@kbn/response-ops-alerts-filters-form/utils/filters");
var _solutions = require("@kbn/response-ops-alerts-filters-form/utils/solutions");
var _use_get_internal_rule_types_query = require("@kbn/response-ops-rules-apis/hooks/use_get_internal_rule_types_query");
var _useEffectOnce = _interopRequireDefault(require("react-use/lib/useEffectOnce"));
var _translations = require("@kbn/response-ops-alerts-filters-form/translations");
var _filters_metadata = require("@kbn/response-ops-alerts-filters-form/filters_metadata");
var _constants = require("../constants");
var _translations2 = require("../translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/embeddable_alerts_table/public/components/config_editor_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EMPTY_FILTERS = [{
  filter: {}
}];
const computeFiltersErrors = expression => {
  return expression === null || expression === void 0 ? void 0 : expression.map(item => {
    if (!(0, _filters.isFilter)(item)) {
      return undefined;
    }
    if (!item.filter.type && expression.length > 1) {
      // The user can leave the default filter empty if it's the only one
      return {
        type: _translations.FILTER_TYPE_REQUIRED_ERROR_MESSAGE
      };
    }
    if (item.filter.type) {
      const {
        isEmpty
      } = (0, _filters_metadata.getFilterMetadata)(item.filter.type);
      if (isEmpty(item.filter.value)) {
        return {
          value: _translations.FILTER_VALUE_REQUIRED_ERROR_MESSAGE
        };
      }
    }
  });
};
const ConfigEditorContent = ({
  initialConfig,
  onSave,
  onCancel,
  services,
  ariaLabelledBy
}) => {
  var _initialConfig$query$, _initialConfig$query, _initialConfig$soluti;
  const {
    http,
    overlays
  } = services;
  const flyoutBodyRef = (0, _react.useRef)(null);
  const solutionSelectorRef = (0, _react.useRef)(null);
  const [filters, setFilters] = (0, _react.useState)((_initialConfig$query$ = initialConfig === null || initialConfig === void 0 ? void 0 : (_initialConfig$query = initialConfig.query) === null || _initialConfig$query === void 0 ? void 0 : _initialConfig$query.filters) !== null && _initialConfig$query$ !== void 0 ? _initialConfig$query$ : EMPTY_FILTERS);
  const {
    data: ruleTypes,
    isLoading: isLoadingRuleTypes,
    isError: cannotLoadRuleTypes
  } = (0, _use_get_internal_rule_types_query.useGetInternalRuleTypesQuery)({
    http
  });
  const availableSolutions = (0, _react.useMemo)(() => ruleTypes ? (0, _solutions.getAvailableSolutions)(ruleTypes) : undefined, [ruleTypes]);
  const [solution, setSolution] = (0, _react.useState)((_initialConfig$soluti = initialConfig === null || initialConfig === void 0 ? void 0 : initialConfig.solution) !== null && _initialConfig$soluti !== void 0 ? _initialConfig$soluti : availableSolutions && availableSolutions.length === 1 ? availableSolutions[0] : undefined);
  const ruleTypeIds = (0, _react.useMemo)(() => !ruleTypes || !solution ? [] : (0, _solutions.getRuleTypeIdsForSolution)(ruleTypes, solution), [ruleTypes, solution]);
  const [filtersErrors, setFiltersErrors] = (0, _react.useState)([]);
  const validateFilters = (0, _react.useCallback)(() => {
    const errors = filters ? computeFiltersErrors(filters) : [];
    setFiltersErrors(errors);
    return !Boolean(errors === null || errors === void 0 ? void 0 : errors.some(error => error));
  }, [filters]);
  const handleFiltersChange = newFilters => {
    setFiltersErrors([]);
    setFilters(newFilters);
  };
  const resetFilters = (0, _react.useCallback)(() => {
    setFilters(EMPTY_FILTERS);
  }, []);
  const onSolutionChange = (0, _react.useCallback)(newSolution => {
    if (solution != null && newSolution !== solution && filters != null && !(0, _filters.isEmptyExpression)(filters)) {
      // Filters are incompatible between different solutions and thus must be reset
      // Ask for confirmation before doing so
      overlays.openConfirm(_translations2.SWITCH_SOLUTION_CONFIRM_MESSAGE, {
        title: _translations2.SWITCH_SOLUTION_CONFIRM_TITLE,
        buttonColor: 'danger',
        cancelButtonText: _translations2.SWITCH_SOLUTION_CONFIRM_CANCEL_MESSAGE,
        confirmButtonText: _translations2.SWITCH_SOLUTION_CONFIRM_CONFIRM_MESSAGE
      }).then(result => {
        if (result) {
          // User accepted to switch solution
          setSolution(newSolution);
          resetFilters();
        }
      });
    } else {
      setSolution(newSolution);
    }
  }, [filters, overlays, resetFilters, solution]);
  (0, _useEffectOnce.default)(() => {
    if (!solution && flyoutBodyRef.current) {
      const panel = flyoutBodyRef.current.closest('.euiFlyout');
      // Waiting for the flyuot entry animation to finish before auto-opening the solution
      // selector, otherwise the options popover cannot position itself correctly
      panel === null || panel === void 0 ? void 0 : panel.addEventListener('animationend', () => {
        var _solutionSelectorRef$;
        return (_solutionSelectorRef$ = solutionSelectorRef.current) === null || _solutionSelectorRef$ === void 0 ? void 0 : _solutionSelectorRef$.openPopover();
      }, {
        once: true
      });
      return () => panel === null || panel === void 0 ? void 0 : panel.removeEventListener('animationend', focus);
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    id: ariaLabelledBy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 11
    }
  }, !initialConfig ? _translations2.CONFIG_EDITOR_ADD_TABLE_TITLE : _translations2.CONFIG_EDITOR_EDIT_TABLE_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    ref: flyoutBodyRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 13
    }
  }, _translations2.CONFIG_EDITOR_PANEL_DESCRIPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 11
    }
  }, availableSolutions && availableSolutions.length > 1 && /*#__PURE__*/_react.default.createElement(_alerts_solution_selector.AlertsSolutionSelector, {
    ref: solutionSelectorRef,
    availableSolutions: availableSolutions,
    isLoading: isLoadingRuleTypes,
    isError: cannotLoadRuleTypes,
    solution: solution,
    onSolutionChange: onSolutionChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 15
    }
  })), solution && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 25
    }
  }, _translations2.CONFIG_EDITOR_FILTERS_FORM_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: resetFilters,
    iconType: "eraser",
    flush: "right",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 23
    }
  }, _translations2.CONFIG_EDITOR_CLEAR_FILTERS_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 17
    }
  }, isLoadingRuleTypes ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 21
    }
  }) : cannotLoadRuleTypes ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "error",
    title: _translations2.CONFIG_EDITOR_CANNOT_LOAD_RULE_TYPES_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 23
    }
  }, _translations2.CONFIG_EDITOR_CANNOT_LOAD_RULE_TYPES_DESCRIPTION)) : /*#__PURE__*/_react.default.createElement(_alerts_filters_form.AlertsFiltersForm, {
    ruleTypeIds: ruleTypeIds,
    value: filters,
    errors: filtersErrors,
    onChange: handleFiltersChange,
    services: services,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 21
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    flush: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 13
    }
  }, _translations2.CONFIG_EDITOR_EDITOR_CLOSE_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isDisabled: !solution || cannotLoadRuleTypes,
    onClick: () => {
      if (validateFilters()) {
        onSave({
          solution: solution,
          query: {
            type: 'alertsFilters',
            filters: filters
          }
        });
      }
    },
    fill: true,
    "data-test-subj": _constants.SAVE_CONFIG_BUTTON_SUBJ,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 13
    }
  }, _translations2.CONFIG_EDITOR_EDITOR_SAVE_LABEL)))));
};
exports.ConfigEditorContent = ConfigEditorContent;