"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DynamicActionStorage = void 0;
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/ui-actions-enhanced-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DynamicActionStorage extends _public2.UiActionsEnhancedAbstractActionStorage {
  constructor(id, getPanelTitle, api) {
    super();
    this.id = id;
    this.getPanelTitle = getPanelTitle;
    this.api = api;
  }
  put(dynamicActionsState) {
    this.api.setDynamicActions({
      dynamicActions: dynamicActionsState
    });
  }
  async create(event) {
    const events = this.getEvents();
    const exists = !!events.find(({
      eventId
    }) => eventId === event.eventId);
    if (exists) {
      throw new Error(`[EEXIST]: Event with [eventId = ${event.eventId}] already exists on ` + `[embeddable.id = ${this.id}, embeddable.title = ${this.getPanelTitle()}].`);
    }
    this.put({
      events: [...events, event]
    });
  }
  async update(event) {
    const dynamicActionsState = this.api.dynamicActionsState$.getValue();
    const events = this.getEvents();
    const index = events.findIndex(({
      eventId
    }) => eventId === event.eventId);
    if (index === -1) {
      throw new Error(`[ENOENT]: Event with [eventId = ${event.eventId}] could not be ` + `updated as it does not exist in ` + `[embeddable.id = ${this.id}, embeddable.title = ${this.getPanelTitle()}].`);
    }
    this.put({
      ...dynamicActionsState,
      events: [...events.slice(0, index), event, ...events.slice(index + 1)]
    });
  }
  async remove(eventId) {
    const dynamicActionsState = this.api.dynamicActionsState$.getValue();
    const events = this.getEvents();
    const index = events.findIndex(event => eventId === event.eventId);
    if (index === -1) {
      throw new Error(`[ENOENT]: Event with [eventId = ${eventId}] could not be ` + `removed as it does not exist in ` + `[embeddable.id = ${this.id}, embeddable.title = ${this.getPanelTitle()}].`);
    }
    this.put({
      ...dynamicActionsState,
      events: [...events.slice(0, index), ...events.slice(index + 1)]
    });
  }
  async read(eventId) {
    const events = this.getEvents();
    const event = events.find(ev => eventId === ev.eventId);
    if (!event) {
      throw new Error(`[ENOENT]: Event with [eventId = ${eventId}] could not be found in ` + `[embeddable.id = ${this.id}, embeddable.title = ${this.getPanelTitle()}].`);
    }
    return event;
  }
  async list() {
    return this.getEvents();
  }
  getEvents() {
    var _dynamicActionsState$, _dynamicActionsState$2;
    const dynamicActionsState = this.api.dynamicActionsState$.getValue();
    const events = (_dynamicActionsState$ = dynamicActionsState === null || dynamicActionsState === void 0 ? void 0 : (_dynamicActionsState$2 = dynamicActionsState.dynamicActions) === null || _dynamicActionsState$2 === void 0 ? void 0 : _dynamicActionsState$2.events) !== null && _dynamicActionsState$ !== void 0 ? _dynamicActionsState$ : [];
    return this.migrate(events);
  }

  // TODO: https://github.com/elastic/kibana/issues/148005
  // Migration implementation should use registry
  // Action factories implementations should register own migrations
  migrate(events) {
    return events.map(event => {
      // Initially dashboard drilldown relied on VALUE_CLICK & RANGE_SELECT
      if (event.action.factoryId === 'DASHBOARD_TO_DASHBOARD_DRILLDOWN') {
        const migratedTriggers = event.triggers.filter(t => t !== _public.VALUE_CLICK_TRIGGER && t !== _public.SELECT_RANGE_TRIGGER);
        if (migratedTriggers.length !== event.triggers.length && !migratedTriggers.includes(`FILTER_TRIGGER`)) {
          migratedTriggers.push(`FILTER_TRIGGER`);
        }
        return {
          ...event,
          triggers: migratedTriggers
        };
      }
      return event;
    });
  }
}
exports.DynamicActionStorage = DynamicActionStorage;