"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../shared/kibana");
var _licensing = require("../../../shared/licensing");
var _licensing_callout = require("../../../shared/licensing_callout/licensing_callout");
var _add_analytics_collection = require("../add_analytics_collections/add_analytics_collection");
var _page_template = require("../layout/page_template");
var _analytics_collection_table = require("./analytics_collection_table");
var _analytics_collections_logic = require("./analytics_collections_logic");
var _analytics_overview_empty_page = require("./analytics_overview_empty_page");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/analytics/components/analytics_overview/analytics_overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AnalyticsOverview = () => {
  const {
    fetchAnalyticsCollections,
    searchAnalyticsCollections
  } = (0, _kea.useActions)(_analytics_collections_logic.AnalyticsCollectionsLogic);
  const {
    analyticsCollections,
    hasNoAnalyticsCollections,
    isFetching,
    isSearching
  } = (0, _kea.useValues)(_analytics_collections_logic.AnalyticsCollectionsLogic);
  const {
    isCloud
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const isGated = !isCloud && !hasPlatinumLicense;
  (0, _react.useEffect)(() => {
    if (isGated) return;
    fetchAnalyticsCollections();
  }, []);
  return /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchAnalyticsPageTemplate, {
    pageChrome: [],
    restrictWidth: true,
    isLoading: isFetching && !isGated,
    pageViewTelemetry: "Analytics Collections Overview",
    pageHeader: {
      description: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.pageDescription', {
        defaultMessage: 'Dashboards and tools for visualizing end-user behavior and measuring the performance of your search applications. Track trends over time, identify and investigate anomalies, and make optimizations.'
      }),
      pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        responsive: false,
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 61,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("h1", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.pageTitle', {
        defaultMessage: 'Behavioral Analytics'
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "warning",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.deprecatedBadge', {
        defaultMessage: 'Deprecated'
      })))),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_add_analytics_collection.AddAnalyticsCollection, {
        disabled: isGated,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 26
        }
      })]
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }, isGated ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_licensing_callout.LicensingCallout, {
    feature: _licensing_callout.LICENSING_FEATURE.ANALYTICS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  })) : hasNoAnalyticsCollections && !isSearching ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_analytics_overview_empty_page.AnalyticsOverviewEmptyPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_analytics_collection_table.AnalyticsCollectionTable, {
    collections: analyticsCollections,
    isSearching: isSearching,
    onSearch: searchAnalyticsCollections,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }));
};
exports.AnalyticsOverview = AnalyticsOverview;