"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddIndicesLogic = void 0;
var _kea = require("kea");
var _update_search_application_api_logic = require("../../api/search_applications/update_search_application_api_logic");
var _search_application_indices_logic = require("./search_application_indices_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddIndicesLogic = exports.AddIndicesLogic = (0, _kea.kea)({
  actions: {
    setSelectedIndices: indices => ({
      indices
    }),
    submitSelectedIndices: () => true
  },
  connect: {
    actions: [_search_application_indices_logic.SearchApplicationIndicesLogic, ['addIndicesToSearchApplication', 'searchApplicationUpdated', 'closeAddIndicesFlyout']],
    values: [_update_search_application_api_logic.UpdateSearchApplicationApiLogic, ['status as updateSearchApplicationStatus', 'error as updateSearchApplicationError']]
  },
  listeners: ({
    actions,
    values
  }) => ({
    searchApplicationUpdated: () => {
      actions.closeAddIndicesFlyout();
    },
    submitSelectedIndices: () => {
      const {
        selectedIndices
      } = values;
      if (selectedIndices.length === 0) return;
      actions.addIndicesToSearchApplication(selectedIndices);
    }
  }),
  path: ['enterprise_search', 'content', 'add_indices_logic'],
  reducers: {
    selectedIndices: [[], {
      closeAddIndicesFlyout: () => [],
      setSelectedIndices: (_, {
        indices
      }) => indices
    }]
  }
});