"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldValueCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _convert_results = require("./convert_results");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/applications/components/search_application/docs_explorer/field_value_cell.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FieldValueCell = ({
  value
}) => {
  const {
    euiTheme,
    colorMode
  } = (0, _eui.useEuiTheme)();
  if ((0, _convert_results.isFieldValue)(value)) {
    if (value.snippet) {
      const [snippet] = value.snippet;
      // https://github.com/elastic/eui/blob/c4afd758e4c42ba6b12ea58ccfd6486d5f544afb/src/components/mark/mark.styles.ts#L29-L36
      const transparency = {
        DARK: 0.3,
        LIGHT: 0.1
      };
      return /*#__PURE__*/_react.default.createElement("span", {
        // eslint-disable-next-line react/no-danger
        dangerouslySetInnerHTML: {
          __html: snippet
        },
        css: (0, _react2.css)`
            & em {
              font-style: normal;
              font-weight: ${euiTheme.font.weight.bold};
              background-color: ${(0, _eui.transparentize)(euiTheme.colors.primary, transparency[colorMode])};
              color: ${euiTheme.colors.text};
            }
          `,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 30,
          columnNumber: 9
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(FieldValueCell, {
      value: value.raw,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 7
      }
    });
  }
  if (typeof value === 'string') {
    return /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 12
      }
    }, value);
  }
  return /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 10
    }
  }, JSON.stringify(value));
};
exports.FieldValueCell = FieldValueCell;