"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchMlInferencePipelines = exports.FetchMlInferencePipelinesApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchMlInferencePipelines = async () => {
  const route = '/internal/enterprise_search/pipelines/ml_inference';
  return await _http.HttpLogic.values.http.get(route);
};
exports.fetchMlInferencePipelines = fetchMlInferencePipelines;
const FetchMlInferencePipelinesApiLogic = exports.FetchMlInferencePipelinesApiLogic = (0, _create_api_logic.createApiLogic)(['fetch_ml_inference_pipelines_api_logic'], fetchMlInferencePipelines);