"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndicesSearchResultProvider = getIndicesSearchResultProvider;
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _get_index_data = require("../lib/indices/utils/get_index_data");
var _calculate_search_score = require("./calculate_search_score");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getIndicesSearchResultProvider(staticAssets) {
  return {
    find: ({
      term,
      types,
      tags
    }, {
      aborted$,
      client,
      maxResults
    }) => {
      if (!client || !term || tags || types && !types.includes('indices')) {
        return (0, _rxjs.from)([[]]);
      }
      const fetchIndices = async () => {
        const {
          indexNames
        } = await (0, _get_index_data.getIndexData)(client, false, false, term);
        const searchResults = indexNames.map(indexName => {
          const score = (0, _calculate_search_score.calculateScore)(term, indexName);
          return {
            icon: staticAssets.getPluginAssetHref('images/index.svg'),
            id: indexName,
            score,
            title: indexName,
            type: _i18n.i18n.translate('xpack.enterpriseSearch.searchIndexProvider.type.name', {
              defaultMessage: 'Index'
            }),
            url: {
              path: `${_constants.ENTERPRISE_SEARCH_DATA_PLUGIN.URL}/search_indices/${indexName}`,
              prependBasePath: true
            }
          };
        }).filter(({
          score
        }) => score > 0).slice(0, maxResults);
        return searchResults;
      };
      return (0, _rxjs.from)(fetchIndices()).pipe((0, _rxjs.takeUntil)(aborted$));
    },
    getSearchableTypes: () => ['indices'],
    id: 'enterpriseSearchIndices'
  };
}