// DO NOT MODIFY THIS FILE BY HAND. IT IS MANAGED BY A CI JOB.

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
parser grammar esql_parser;

@header {
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
}

options {
  superClass=parser_config;
  tokenVocab=esql_lexer;
}

import Expression,
       Join;

statements
    : {this.isDevVersion()}? setCommand+ singleStatement EOF
    | singleStatement EOF
    ;

singleStatement
    : query EOF
    ;

query
    : sourceCommand                 #singleCommandQuery
    | query PIPE processingCommand  #compositeQuery
    ;

sourceCommand
    : fromCommand
    | rowCommand
    | showCommand
    | timeSeriesCommand
    // in development
    | {this.isDevVersion()}? explainCommand
    ;

processingCommand
    : evalCommand
    | whereCommand
    | keepCommand
    | limitCommand
    | statsCommand
    | sortCommand
    | dropCommand
    | renameCommand
    | dissectCommand
    | grokCommand
    | enrichCommand
    | mvExpandCommand
    | joinCommand
    | changePointCommand
    | completionCommand
    | sampleCommand
    | forkCommand
    | rerankCommand
    | inlineStatsCommand
    // in development
    | {this.isDevVersion()}? lookupCommand
    | {this.isDevVersion()}? insistCommand
    | {this.isDevVersion()}? fuseCommand
    ;

whereCommand
    : WHERE booleanExpression
    ;

dataType
    : identifier                                                                        #toDataType
    ;

rowCommand
    : ROW fields
    ;

fields
    : field (COMMA field)*
    ;

field
    : (qualifiedName ASSIGN)? booleanExpression
    ;

rerankFields
    : rerankField (COMMA rerankField)*
    ;

rerankField
    : qualifiedName (ASSIGN booleanExpression)?
    ;

fromCommand
    : FROM indexPatternAndMetadataFields
    ;

timeSeriesCommand
    : TS indexPatternAndMetadataFields
    ;

indexPatternAndMetadataFields:
    indexPattern (COMMA indexPattern)* metadata?
    ;

indexPattern
    : clusterString COLON unquotedIndexString
    | unquotedIndexString CAST_OP selectorString
    | indexString
    ;

clusterString
    : UNQUOTED_SOURCE
    ;

selectorString
    : UNQUOTED_SOURCE
    ;

unquotedIndexString
    : UNQUOTED_SOURCE
    ;

indexString
    : UNQUOTED_SOURCE
    | QUOTED_STRING
    ;

metadata
    : METADATA UNQUOTED_SOURCE (COMMA UNQUOTED_SOURCE)*
    ;

evalCommand
    : EVAL fields
    ;

statsCommand
    : STATS stats=aggFields? (BY grouping=fields)?
    ;

aggFields
    : aggField (COMMA aggField)*
    ;

aggField
    : field (WHERE booleanExpression)?
    ;

qualifiedName
    : {this.isDevVersion()}? OPENING_BRACKET qualifier=UNQUOTED_IDENTIFIER? CLOSING_BRACKET DOT OPENING_BRACKET name=fieldName CLOSING_BRACKET
    | name=fieldName
    ;

fieldName
    : identifierOrParameter (DOT identifierOrParameter)*
    ;

qualifiedNamePattern
    : {this.isDevVersion()}? OPENING_BRACKET qualifier=ID_PATTERN? CLOSING_BRACKET DOT OPENING_BRACKET name=fieldNamePattern CLOSING_BRACKET
    | name=fieldNamePattern
    ;

fieldNamePattern
    : (identifierPattern (DOT identifierPattern)*)
    ;

qualifiedNamePatterns
    : qualifiedNamePattern (COMMA qualifiedNamePattern)*
    ;

identifier
    : UNQUOTED_IDENTIFIER
    | QUOTED_IDENTIFIER
    ;

identifierPattern
    : ID_PATTERN
    | parameter
    | doubleParameter
    ;

parameter
    : PARAM                        #inputParam
    | NAMED_OR_POSITIONAL_PARAM    #inputNamedOrPositionalParam
    ;

doubleParameter
    : DOUBLE_PARAMS                        #inputDoubleParams
    | NAMED_OR_POSITIONAL_DOUBLE_PARAMS    #inputNamedOrPositionalDoubleParams
    ;

identifierOrParameter
    : identifier
    | parameter
    | doubleParameter
    ;

limitCommand
    : LIMIT constant
    ;

sortCommand
    : SORT orderExpression (COMMA orderExpression)*
    ;

orderExpression
    : booleanExpression ordering=(ASC | DESC)? (NULLS nullOrdering=(FIRST | LAST))?
    ;

keepCommand
    :  KEEP qualifiedNamePatterns
    ;

dropCommand
    : DROP qualifiedNamePatterns
    ;

renameCommand
    : RENAME renameClause (COMMA renameClause)*
    ;

renameClause:
    oldName=qualifiedNamePattern AS newName=qualifiedNamePattern
    | newName=qualifiedNamePattern ASSIGN oldName=qualifiedNamePattern
    ;

dissectCommand
    : DISSECT primaryExpression string dissectCommandOptions?
    ;

dissectCommandOptions
    : dissectCommandOption (COMMA dissectCommandOption)*
    ;

dissectCommandOption
    : identifier ASSIGN constant
    ;


commandNamedParameters
    : (WITH mapExpression)?
    ;

grokCommand
    : GROK primaryExpression string
    ;

mvExpandCommand
    : MV_EXPAND qualifiedName
    ;

explainCommand
    : DEV_EXPLAIN subqueryExpression
    ;

subqueryExpression
    : LP query RP
    ;

showCommand
    : SHOW INFO                                                           #showInfo
    ;

enrichCommand
    : ENRICH policyName=enrichPolicyName (ON matchField=qualifiedNamePattern)? (WITH enrichWithClause (COMMA enrichWithClause)*)?
    ;

enrichPolicyName
    : ENRICH_POLICY_NAME
    | QUOTED_STRING
    ;

enrichWithClause
    : (newName=qualifiedNamePattern ASSIGN)? enrichField=qualifiedNamePattern
    ;

sampleCommand
    : SAMPLE probability=constant
    ;

changePointCommand
    : CHANGE_POINT value=qualifiedName (ON key=qualifiedName)? (AS targetType=qualifiedName COMMA targetPvalue=qualifiedName)?
    ;

forkCommand
    : FORK forkSubQueries
    ;

forkSubQueries
    : (forkSubQuery)+
    ;

forkSubQuery
    : LP forkSubQueryCommand RP
    ;

forkSubQueryCommand
    : forkSubQueryProcessingCommand                             #singleForkSubQueryCommand
    | forkSubQueryCommand PIPE forkSubQueryProcessingCommand    #compositeForkSubQuery
    ;

forkSubQueryProcessingCommand
    : processingCommand
    ;

rerankCommand
    : RERANK (targetField=qualifiedName ASSIGN)? queryText=constant ON rerankFields commandNamedParameters
    ;

completionCommand
    : COMPLETION (targetField=qualifiedName ASSIGN)? prompt=primaryExpression commandNamedParameters
    ;

inlineStatsCommand
    : INLINE INLINE_STATS stats=aggFields (BY grouping=fields)?
    // TODO: drop after next minor release
    | INLINESTATS stats=aggFields (BY grouping=fields)?
    ;

//
// In development
//
lookupCommand
    : DEV_LOOKUP tableName=indexPattern ON matchFields=qualifiedNamePatterns
    ;

insistCommand
    : DEV_INSIST qualifiedNamePatterns
    ;

fuseCommand
    : DEV_FUSE (fuseType=identifier)? (fuseConfiguration)*
    ;

fuseConfiguration
    : SCORE BY score=qualifiedName
    | KEY BY key=fields
    | GROUP BY group=qualifiedName
    | WITH options=mapExpression
    ;

setCommand
    : SET setField SEMICOLON
    ;

setField
    : identifier ASSIGN constant
    ;