"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.autocomplete = autocomplete;
var _i18n = require("@kbn/i18n");
var _helpers = require("../../../definitions/utils/autocomplete/helpers");
var _complete_items = require("../../complete_items");
var _utils = require("./utils");
var _sources = require("../../../definitions/utils/sources");
var _ = require("../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function autocomplete(query, command, callbacks, context, cursorPosition) {
  if (!(callbacks !== null && callbacks !== void 0 && callbacks.getByType) || !(callbacks !== null && callbacks !== void 0 && callbacks.getColumnsForQuery)) {
    return [];
  }
  const innerText = query.substring(0, cursorPosition);
  let commandText = innerText;
  if (command.location) {
    commandText = innerText.slice(command.location.min);
  }
  const position = (0, _utils.getPosition)(commandText);
  switch (position.pos) {
    case 'type':
    case 'after_type':
    case 'mnemonic':
      {
        const joinCommandDefinition = _.esqlCommandRegistry.getCommandByName('join');
        const allMnemonics = (0, _utils.getFullCommandMnemonics)(joinCommandDefinition);
        const filteredMnemonics = allMnemonics.filter(([mnemonic]) => mnemonic.startsWith(commandText.toUpperCase()));
        if (!filteredMnemonics.length) {
          return [];
        }
        return filteredMnemonics.map(([mnemonic, description], i) => (0, _helpers.withAutoSuggest)({
          label: mnemonic,
          text: mnemonic + ' $0',
          asSnippet: true,
          detail: description,
          kind: 'Keyword',
          sortText: `${i}-MNEMONIC`
        }));
      }
    case 'after_mnemonic':
    case 'index':
      {
        var _commandText$split$po, _await$callbacks$canC, _callbacks$canCreateL;
        const indexNameInput = (_commandText$split$po = commandText.split(' ').pop()) !== null && _commandText$split$po !== void 0 ? _commandText$split$po : '';
        const joinSources = context === null || context === void 0 ? void 0 : context.joinSources;
        const suggestions = [];
        const canCreate = (_await$callbacks$canC = await (callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$canCreateL = callbacks.canCreateLookupIndex) === null || _callbacks$canCreateL === void 0 ? void 0 : _callbacks$canCreateL.call(callbacks, indexNameInput))) !== null && _await$callbacks$canC !== void 0 ? _await$callbacks$canC : false;
        const indexAlreadyExists = joinSources === null || joinSources === void 0 ? void 0 : joinSources.some(source => source.name === indexNameInput || source.aliases.includes(indexNameInput));
        if (canCreate && !indexAlreadyExists) {
          const createIndexCommandSuggestion = (0, _helpers.getLookupIndexCreateSuggestion)(innerText, indexNameInput);
          suggestions.push(createIndexCommandSuggestion);
        }
        if (joinSources !== null && joinSources !== void 0 && joinSources.length) {
          const joinIndexesSuggestions = (0, _sources.specialIndicesToSuggestions)(joinSources);
          suggestions.push(...(await (0, _helpers.handleFragment)(innerText, fragment => (0, _sources.specialIndicesToSuggestions)(joinSources).some(({
            label
          }) => label.toLocaleLowerCase() === fragment.toLocaleLowerCase()), (_fragment, rangeToReplace) => joinIndexesSuggestions.map(suggestion => ({
            ...suggestion,
            rangeToReplace
          })), () => [])));
        }
        return suggestions;
      }
    case 'after_index':
      {
        const suggestion = (0, _helpers.withAutoSuggest)({
          label: 'ON',
          text: 'ON ',
          detail: _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.join.onKeyword', {
            defaultMessage: 'Specify JOIN field conditions'
          }),
          kind: 'Keyword',
          sortText: '0-ON'
        });
        return [suggestion];
      }
    case 'after_on':
      {
        return await (0, _utils.suggestFields)(innerText, command, callbacks === null || callbacks === void 0 ? void 0 : callbacks.getByType, callbacks === null || callbacks === void 0 ? void 0 : callbacks.getColumnsForQuery, context);
      }
    case 'condition':
      {
        if (/(?<!\,)\s+$/.test(innerText)) {
          // this trailing whitespace was not proceeded by a comma
          return [_complete_items.commaCompleteItem, _complete_items.pipeCompleteItem];
        }
        const fields = await (0, _utils.suggestFields)(innerText, command, callbacks === null || callbacks === void 0 ? void 0 : callbacks.getByType, callbacks === null || callbacks === void 0 ? void 0 : callbacks.getColumnsForQuery, context);
        return fields;
      }
  }
  const suggestions = [];
  return suggestions;
}