"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timeUnitsToSuggest = exports.FULL_TEXT_SEARCH_FUNCTIONS = exports.EDITOR_MARKER = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const EDITOR_MARKER = exports.EDITOR_MARKER = 'marker_esql_editor';

// List for suggestions (human-friendly)
const timeUnitsToSuggest = exports.timeUnitsToSuggest = [{
  name: 'year',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.dateDurationDefinition.year', {
    defaultMessage: 'Year'
  })
}, {
  name: 'years',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.dateDurationDefinition.years', {
    defaultMessage: 'Years (Plural)'
  })
}, {
  name: 'quarter',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.dateDurationDefinition.quarter', {
    defaultMessage: 'Quarter'
  })
}, {
  name: 'quarters',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.dateDurationDefinition.quarters', {
    defaultMessage: 'Quarters (Plural)'
  })
}, {
  name: 'month',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.dateDurationDefinition.month', {
    defaultMessage: 'Month'
  })
}, {
  name: 'months',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.dateDurationDefinition.months', {
    defaultMessage: 'Months (Plural)'
  })
}, {
  name: 'week',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.dateDurationDefinition.week', {
    defaultMessage: 'Week'
  })
}, {
  name: 'weeks',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.dateDurationDefinition.weeks', {
    defaultMessage: 'Weeks (Plural)'
  })
}, {
  name: 'day',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.dateDurationDefinition.day', {
    defaultMessage: 'Day'
  })
}, {
  name: 'days',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.dateDurationDefinition.days', {
    defaultMessage: 'Days (Plural)'
  })
}, {
  name: 'hour',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.dateDurationDefinition.hour', {
    defaultMessage: 'Hour'
  })
}, {
  name: 'hours',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.dateDurationDefinition.hours', {
    defaultMessage: 'Hours (Plural)'
  })
}, {
  name: 'minute',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.dateDurationDefinition.minute', {
    defaultMessage: 'Minute'
  })
}, {
  name: 'minutes',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.dateDurationDefinition.minutes', {
    defaultMessage: 'Minutes (Plural)'
  })
}, {
  name: 'second',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.dateDurationDefinition.second', {
    defaultMessage: 'Second'
  })
}, {
  name: 'seconds',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.dateDurationDefinition.seconds', {
    defaultMessage: 'Seconds (Plural)'
  })
}, {
  name: 'millisecond',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.dateDurationDefinition.millisecond', {
    defaultMessage: 'Millisecond'
  })
}, {
  name: 'milliseconds',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.dateDurationDefinition.milliseconds', {
    defaultMessage: 'Milliseconds (Plural)'
  })
}];
const FULL_TEXT_SEARCH_FUNCTIONS = exports.FULL_TEXT_SEARCH_FUNCTIONS = ['match', 'match_operator', 'qstr', 'kql'];