"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateSources = validateSources;
var _sources = require("../sources");
var _errors = require("../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function hasWildcard(name) {
  return /\*/.test(name);
}
function validateSources(sources, context) {
  var _context$sources;
  const messages = [];
  const sourcesMap = new Set((context === null || context === void 0 ? void 0 : (_context$sources = context.sources) === null || _context$sources === void 0 ? void 0 : _context$sources.map(source => source.name)) || []);
  const knownIndexNames = [];
  const knownIndexPatterns = [];
  const unknownIndexNames = [];
  const unknownIndexPatterns = [];
  for (const source of sources) {
    if (source.incomplete) {
      return messages;
    }
    if (source.sourceType === 'index') {
      const index = source.index;
      const sourceName = source.prefix ? source.name : index === null || index === void 0 ? void 0 : index.valueUnquoted;
      if (!sourceName) continue;
      if ((0, _sources.sourceExists)(sourceName, sourcesMap) && !hasWildcard(sourceName)) {
        knownIndexNames.push(source);
      }
      if ((0, _sources.sourceExists)(sourceName, sourcesMap) && hasWildcard(sourceName)) {
        knownIndexPatterns.push(source);
      }
      if (!(0, _sources.sourceExists)(sourceName, sourcesMap) && !hasWildcard(sourceName)) {
        unknownIndexNames.push(source);
      }
      if (!(0, _sources.sourceExists)(sourceName, sourcesMap) && hasWildcard(sourceName)) {
        unknownIndexPatterns.push(source);
      }
    }
  }
  unknownIndexNames.forEach(source => {
    messages.push((0, _errors.getMessageFromId)({
      messageId: 'unknownIndex',
      values: {
        name: source.name
      },
      locations: source.location
    }));
  });
  if (knownIndexNames.length + unknownIndexNames.length + knownIndexPatterns.length === 0) {
    // only if there are no known index names, no known index patterns, and no unknown
    // index names do we worry about creating errors for unknown index patterns
    unknownIndexPatterns.forEach(source => {
      messages.push((0, _errors.getMessageFromId)({
        messageId: 'unknownIndex',
        values: {
          name: source.name
        },
        locations: source.location
      }));
    });
  }
  return messages;
}