"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColumnsByTypeRetriever = getColumnsByTypeRetriever;
exports.suggest = suggest;
var _esqlAst = require("@kbn/esql-ast");
var _recommended_queries = require("@kbn/esql-ast/src/commands_registry/options/recommended_queries");
var _utils = require("@kbn/esql-ast/src/definitions/utils");
var _ast = require("@kbn/esql-ast/src/definitions/utils/ast");
var _esqlTypes = require("@kbn/esql-types");
var _context = require("../shared/context");
var _helpers = require("../shared/helpers");
var _resources_helpers = require("../shared/resources_helpers");
var _get_command_context = require("./get_command_context");
var _recommended_queries_helpers = require("./utils/recommended_queries_helpers");
var _get_query_for_fields = require("./get_query_for_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function suggest(fullText, offset, resourceRetriever) {
  var _resourceRetriever$ca, _resourceRetriever$ca2, _resourceRetriever$ge, _resourceRetriever$ge2;
  // Partition out to inner ast / ast context for the latest command
  const innerText = fullText.substring(0, offset);
  const correctedQuery = (0, _ast.correctQuerySyntax)(innerText);
  const {
    ast,
    root
  } = (0, _esqlAst.parse)(correctedQuery, {
    withFormatting: true
  });
  const astContext = (0, _context.getAstContext)(innerText, ast, offset);
  if (astContext.type === 'comment') {
    return [];
  }
  const {
    getColumnsByType,
    getColumnMap
  } = getColumnsByTypeRetriever((0, _get_query_for_fields.getQueryForFields)(correctedQuery, root), innerText, resourceRetriever);
  const supportsControls = (_resourceRetriever$ca = resourceRetriever === null || resourceRetriever === void 0 ? void 0 : (_resourceRetriever$ca2 = resourceRetriever.canSuggestVariables) === null || _resourceRetriever$ca2 === void 0 ? void 0 : _resourceRetriever$ca2.call(resourceRetriever)) !== null && _resourceRetriever$ca !== void 0 ? _resourceRetriever$ca : false;
  const getVariables = resourceRetriever === null || resourceRetriever === void 0 ? void 0 : resourceRetriever.getVariables;
  const getSources = (0, _resources_helpers.getSourcesHelper)(resourceRetriever);
  const activeProduct = resourceRetriever === null || resourceRetriever === void 0 ? void 0 : (_resourceRetriever$ge = resourceRetriever.getActiveProduct) === null || _resourceRetriever$ge === void 0 ? void 0 : _resourceRetriever$ge.call(resourceRetriever);
  const licenseInstance = await (resourceRetriever === null || resourceRetriever === void 0 ? void 0 : (_resourceRetriever$ge2 = resourceRetriever.getLicense) === null || _resourceRetriever$ge2 === void 0 ? void 0 : _resourceRetriever$ge2.call(resourceRetriever));
  const hasMinimumLicenseRequired = licenseInstance === null || licenseInstance === void 0 ? void 0 : licenseInstance.hasAtLeast;
  if (astContext.type === 'newCommand') {
    // propose main commands here
    // resolve particular commands suggestions after
    // filter source commands if already defined
    const commands = _esqlAst.esqlCommandRegistry.getAllCommands().filter(command => {
      var _command$metadata, _command$metadata2;
      const license = (_command$metadata = command.metadata) === null || _command$metadata === void 0 ? void 0 : _command$metadata.license;
      const observabilityTier = (_command$metadata2 = command.metadata) === null || _command$metadata2 === void 0 ? void 0 : _command$metadata2.observabilityTier;

      // Check license requirements
      const hasLicenseAccess = !license || (hasMinimumLicenseRequired === null || hasMinimumLicenseRequired === void 0 ? void 0 : hasMinimumLicenseRequired(license.toLocaleLowerCase()));

      // Check observability tier requirements
      const hasObservabilityAccess = !observabilityTier || !activeProduct || activeProduct.type !== 'observability' || activeProduct.tier === observabilityTier.toLocaleLowerCase();
      return hasLicenseAccess && hasObservabilityAccess;
    }).map(command => command.name);
    const suggestions = (0, _esqlAst.getCommandAutocompleteDefinitions)(commands);
    if (!ast.length) {
      // Display the recommended queries if there are no commands (empty state)
      const recommendedQueriesSuggestions = [];
      if (getSources) {
        var _await$resourceRetrie, _resourceRetriever$ge3;
        let fromCommand = '';
        const sources = await getSources();
        const visibleSources = sources.filter(source => !source.hidden);
        if (visibleSources.find(source => source.name.startsWith('logs'))) {
          fromCommand = 'FROM logs*';
        } else if (visibleSources.length) {
          fromCommand = `FROM ${visibleSources[0].name}`;
        }
        const {
          getColumnsByType: getColumnsByTypeEmptyState
        } = getColumnsByTypeRetriever(_esqlAst.EsqlQuery.fromSrc(fromCommand).ast, innerText, resourceRetriever);
        const editorExtensions = (_await$resourceRetrie = await (resourceRetriever === null || resourceRetriever === void 0 ? void 0 : (_resourceRetriever$ge3 = resourceRetriever.getEditorExtensions) === null || _resourceRetriever$ge3 === void 0 ? void 0 : _resourceRetriever$ge3.call(resourceRetriever, 'from *'))) !== null && _await$resourceRetrie !== void 0 ? _await$resourceRetrie : {
          recommendedQueries: []
        };
        const recommendedQueriesSuggestionsFromExtensions = (0, _recommended_queries_helpers.mapRecommendedQueriesFromExtensions)(editorExtensions.recommendedQueries);
        const recommendedQueriesSuggestionsFromStaticTemplates = await (0, _recommended_queries.getRecommendedQueriesSuggestionsFromStaticTemplates)(getColumnsByTypeEmptyState, fromCommand);
        recommendedQueriesSuggestions.push(...recommendedQueriesSuggestionsFromExtensions, ...recommendedQueriesSuggestionsFromStaticTemplates);
      }
      const sourceCommandsSuggestions = suggestions.filter(_helpers.isSourceCommand);
      return [...sourceCommandsSuggestions, ...recommendedQueriesSuggestions];
    }
    return suggestions.filter(def => !(0, _helpers.isSourceCommand)(def));
  }

  // ToDo: Reconsider where it belongs when this is resolved https://github.com/elastic/kibana/issues/216492
  const lastCharacterTyped = innerText[innerText.length - 1];
  let controlSuggestions = [];
  if (lastCharacterTyped === _esqlAst.ESQL_VARIABLES_PREFIX) {
    controlSuggestions = (0, _utils.getControlSuggestionIfSupported)(Boolean(supportsControls), _esqlTypes.ESQLVariableType.VALUES, getVariables === null || getVariables === void 0 ? void 0 : getVariables(), false);
    return controlSuggestions;
  }
  if (astContext.type === 'expression') {
    const commandsSpecificSuggestions = await getSuggestionsWithinCommandExpression(fullText, ast, astContext, getColumnsByType, getColumnMap, resourceRetriever, offset, hasMinimumLicenseRequired);
    return commandsSpecificSuggestions;
  }
  return [];
}
function getColumnsByTypeRetriever(query, queryText, resourceRetriever) {
  var _resourceRetriever$ca3, _resourceRetriever$ca4;
  const helpers = new _resources_helpers.QueryColumns(query, queryText, resourceRetriever);
  const getVariables = resourceRetriever === null || resourceRetriever === void 0 ? void 0 : resourceRetriever.getVariables;
  const canSuggestVariables = (_resourceRetriever$ca3 = resourceRetriever === null || resourceRetriever === void 0 ? void 0 : (_resourceRetriever$ca4 = resourceRetriever.canSuggestVariables) === null || _resourceRetriever$ca4 === void 0 ? void 0 : _resourceRetriever$ca4.call(resourceRetriever)) !== null && _resourceRetriever$ca3 !== void 0 ? _resourceRetriever$ca3 : false;
  const queryString = queryText;
  const lastCharacterTyped = queryString[queryString.length - 1];
  const lastCharIsQuestionMark = lastCharacterTyped === _esqlAst.ESQL_VARIABLES_PREFIX;
  return {
    getColumnsByType: async (expectedType = 'any', ignored = [], options) => {
      var _await$resourceRetrie2, _resourceRetriever$ge4;
      const updatedOptions = {
        ...options,
        supportsControls: canSuggestVariables && !lastCharIsQuestionMark
      };
      const editorExtensions = (_await$resourceRetrie2 = await (resourceRetriever === null || resourceRetriever === void 0 ? void 0 : (_resourceRetriever$ge4 = resourceRetriever.getEditorExtensions) === null || _resourceRetriever$ge4 === void 0 ? void 0 : _resourceRetriever$ge4.call(resourceRetriever, queryText))) !== null && _await$resourceRetrie2 !== void 0 ? _await$resourceRetrie2 : {
        recommendedQueries: [],
        recommendedFields: []
      };
      const recommendedFieldsFromExtensions = editorExtensions.recommendedFields;
      const columns = await helpers.byType(expectedType, ignored);
      return (0, _utils.buildFieldsDefinitionsWithMetadata)(columns, recommendedFieldsFromExtensions, updatedOptions, await (getVariables === null || getVariables === void 0 ? void 0 : getVariables()));
    },
    getColumnMap: helpers.asMap.bind(helpers)
  };
}
function findNewUserDefinedColumn(userDefinedColumns) {
  let autoGeneratedColumnCounter = 0;
  let name = `col${autoGeneratedColumnCounter++}`;
  while (userDefinedColumns.has(name)) {
    name = `col${autoGeneratedColumnCounter++}`;
  }
  return name;
}
async function getSuggestionsWithinCommandExpression(fullText, commands, astContext, getColumnsByType, getColumnMap, callbacks, offset, hasMinimumLicenseRequired) {
  var _callbacks$getActiveP;
  const innerText = fullText.substring(0, offset);
  const commandDefinition = _esqlAst.esqlCommandRegistry.getCommandByName(astContext.command.name);
  if (!commandDefinition) {
    return [];
  }

  // collect all fields + userDefinedColumns to suggest
  const columnMap = await getColumnMap();
  const references = {
    columns: columnMap
  };
  const getSuggestedUserDefinedColumnName = () => {
    const allUserDefinedColumns = new Set(_esqlAst.Walker.findAll(commands, node => node.type === 'column').map(col => col.parts.join('.')));
    return findNewUserDefinedColumn(allUserDefinedColumns);
  };
  const additionalCommandContext = await (0, _get_command_context.getCommandContext)(astContext.command.name, innerText, callbacks);
  const context = {
    ...references,
    ...additionalCommandContext,
    activeProduct: callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$getActiveP = callbacks.getActiveProduct) === null || _callbacks$getActiveP === void 0 ? void 0 : _callbacks$getActiveP.call(callbacks)
  };

  // does it make sense to have a different context per command?
  return commandDefinition.methods.autocomplete(fullText, astContext.command, {
    getByType: getColumnsByType,
    getSuggestedUserDefinedColumnName,
    getColumnsForQuery: callbacks !== null && callbacks !== void 0 && callbacks.getColumnsFor ? async query => {
      return await callbacks.getColumnsFor({
        query
      });
    } : undefined,
    hasMinimumLicenseRequired,
    canCreateLookupIndex: callbacks === null || callbacks === void 0 ? void 0 : callbacks.canCreateLookupIndex
  }, context, offset);
}