"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateESQLQueryAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _update_esql_query_helpers = require("./update_esql_query_helpers");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class UpdateESQLQueryAction {
  constructor(data) {
    (0, _defineProperty2.default)(this, "type", _constants.ACTION_UPDATE_ESQL_QUERY);
    (0, _defineProperty2.default)(this, "id", _constants.ACTION_UPDATE_ESQL_QUERY);
    (0, _defineProperty2.default)(this, "order", 50);
    this.data = data;
  }
  getDisplayName() {
    return _i18n.i18n.translate('esql.updateESQLQueryLabel', {
      defaultMessage: 'Update the ES|QL query in the editor'
    });
  }
  getIconType() {
    return 'filter';
  }
  async isCompatible() {
    return (0, _update_esql_query_helpers.isActionCompatible)(this.data);
  }
  async execute({
    queryString
  }) {
    return (0, _update_esql_query_helpers.executeAction)({
      queryString,
      data: this.data
    });
  }
}
exports.UpdateESQLQueryAction = UpdateESQLQueryAction;