"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.REFRESH_LABEL = void 0;
exports.RefreshButton = RefreshButton;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_series_storage = require("../hooks/use_series_storage");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/header/refresh_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function RefreshButton() {
  const {
    setLastRefresh
  } = (0, _use_series_storage.useSeriesStorage)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "o11yRefreshButtonButton",
    iconType: "refresh",
    onClick: () => setLastRefresh(Date.now()),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 17,
      columnNumber: 5
    }
  }, REFRESH_LABEL);
}
const REFRESH_LABEL = exports.REFRESH_LABEL = _i18n.i18n.translate('xpack.exploratoryView.refresh', {
  defaultMessage: 'Refresh'
});