"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.method = exports.handler = void 0;
exports.register = register;
var _configSchema = require("@kbn/config-schema");
var commonSchemas = _interopRequireWildcard(require("../common_schemas"));
var cs = commonSchemas;
var _api_routes = require("../api_routes");
var _find = require("../find");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const method = exports.method = 'post';
const rt = {
  body: _configSchema.schema.object({
    status: _configSchema.schema.maybe(_find.stringOrArrayOfStrings),
    extension: _configSchema.schema.maybe(_find.stringOrArrayOfStrings),
    mimeType: _configSchema.schema.maybe(_find.stringOrArrayOfStrings),
    name: _configSchema.schema.maybe(_find.nameStringOrArrayOfNameStrings),
    meta: commonSchemas.fileMeta
  }),
  query: _configSchema.schema.object({
    page: _configSchema.schema.maybe(cs.page),
    perPage: _configSchema.schema.maybe(cs.pageSize)
  })
};
const handler = async ({
  files,
  fileKind
}, req, res) => {
  const {
    body: {
      name,
      status,
      extension,
      mimeType,
      meta
    },
    query: {
      page,
      perPage
    }
  } = req;
  const {
    fileService
  } = await files;
  const body = await fileService.asCurrentUser().find({
    kind: [fileKind],
    name: (0, _find.toArrayOrUndefined)(name),
    status: (0, _find.toArrayOrUndefined)(status),
    extension: (0, _find.toArrayOrUndefined)(extension),
    mimeType: (0, _find.toArrayOrUndefined)(mimeType),
    page,
    perPage,
    meta: meta
  });
  return res.ok({
    body
  });
};
exports.handler = handler;
function register(fileKindRouter, fileKind) {
  if (fileKind.http.list) {
    fileKindRouter[method]({
      path: _api_routes.FILES_API_ROUTES.fileKind.getListRoute(fileKind.id),
      validate: {
        ...rt
      },
      security: {
        authz: {
          requiredPrivileges: fileKind.http.list.requiredPrivileges
        }
      }
    }, handler);
  }
}