"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSelectFleetServerPolicy = void 0;
var _react = require("react");
var _hooks = require("../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSelectFleetServerPolicy = defaultAgentPolicyId => {
  var _data$fleet_server3;
  const [fleetServerPolicyId, setFleetServerPolicyId] = (0, _react.useState)(defaultAgentPolicyId);
  const {
    isLoading,
    isInitialRequest,
    data,
    resendRequest
  } = (0, _hooks.useGetEnrollmentSettings)();
  const eligibleFleetServerPolicies = (0, _react.useMemo)(() => {
    var _data$fleet_server, _data$fleet_server2, _data$fleet_server2$p;
    return data !== null && data !== void 0 && (_data$fleet_server = data.fleet_server) !== null && _data$fleet_server !== void 0 && _data$fleet_server.policies ? data === null || data === void 0 ? void 0 : (_data$fleet_server2 = data.fleet_server) === null || _data$fleet_server2 === void 0 ? void 0 : (_data$fleet_server2$p = _data$fleet_server2.policies) === null || _data$fleet_server2$p === void 0 ? void 0 : _data$fleet_server2$p.filter(item => !item.is_managed) : [];
  }, [data === null || data === void 0 ? void 0 : (_data$fleet_server3 = data.fleet_server) === null || _data$fleet_server3 === void 0 ? void 0 : _data$fleet_server3.policies]);
  (0, _react.useEffect)(() => {
    // Default to the first policy found with a fleet server integration installed
    if (eligibleFleetServerPolicies.length === 1 && !fleetServerPolicyId) {
      setFleetServerPolicyId(eligibleFleetServerPolicies[0].id);
    }
  }, [eligibleFleetServerPolicies, fleetServerPolicyId]);
  return {
    isSelectFleetServerPolicyLoading: isLoading && isInitialRequest,
    fleetServerPolicyId,
    setFleetServerPolicyId,
    eligibleFleetServerPolicies: eligibleFleetServerPolicies || [],
    refreshEligibleFleetServerPolicies: resendRequest
  };
};
exports.useSelectFleetServerPolicy = useSelectFleetServerPolicy;