"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstallElasticAgentStandalonePageStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _services = require("../../../../../../../../../../common/services");
var _ = require("../..");
var _components = require("../../../../../../../components");
var _hooks = require("../../../../../../../../../hooks");
var _steps = require("../../../../../../../../../components/agent_enrollment_flyout/steps");
var _enrollment_instructions = require("../../../../../../../../../components/enrollment_instructions");
var _hooks2 = require("../../../../../../../../../components/agent_enrollment_flyout/hooks");
var _use_agent_policies_with_fips = require("../../../../../../../hooks/use_agent_policies_with_fips");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/create_package_policy_page/multi_page_layout/components/page_steps/install_agent/install_agent_standalone.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const InstallElasticAgentStandalonePageStep = props => {
  var _agentPolicy$package_;
  const {
    setIsManaged,
    agentPolicy,
    cancelUrl,
    onNext,
    cancelClickHandler
  } = props;
  const kibanaVersion = (0, _hooks.useKibanaVersion)();
  const [commandCopied, setCommandCopied] = (0, _react.useState)(false);
  const [policyCopied, setPolicyCopied] = (0, _react.useState)(false);
  const {
    yaml,
    onCreateApiKey,
    isCreatingApiKey,
    apiKey,
    downloadYaml
  } = (0, _hooks2.useFetchFullPolicy)(agentPolicy);
  if (!agentPolicy) {
    return /*#__PURE__*/_react.default.createElement(_components.Error, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.createPackagePolicy.errorLoadingPackageTitle",
        defaultMessage: "Error loading package information",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 47,
          columnNumber: 11
        }
      }),
      error: 'Agent policy not provided',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 7
      }
    });
  }
  const installManagedCommands = (0, _enrollment_instructions.StandaloneInstructions)({
    agentVersion: kibanaVersion
  });
  const steps = [(0, _steps.ConfigureStandaloneAgentStep)({
    selectedPolicyId: agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.id,
    yaml,
    downloadYaml,
    apiKey,
    onCreateApiKey,
    isCreatingApiKey,
    isComplete: policyCopied,
    onCopy: () => setPolicyCopied(true)
  }), (0, _steps.InstallStandaloneAgentStep)({
    installCommand: installManagedCommands,
    isComplete: yaml && commandCopied,
    fullCopyButton: true,
    onCopy: () => setCommandCopied(true),
    rootIntegrations: (0, _services.getRootIntegrations)((_agentPolicy$package_ = agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.package_policies) !== null && _agentPolicy$package_ !== void 0 ? _agentPolicy$package_ : []),
    nonFipsIntegrations: (0, _use_agent_policies_with_fips.getAgentPoliciesWithNonFipsIntegrations)(agentPolicy)
  })];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.StandaloneModeWarningCallout, {
    setIsManaged: setIsManaged,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: steps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }), commandCopied && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.NotObscuredByBottomBar, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_.AgentStandaloneBottomBar, {
    cancelUrl: cancelUrl,
    onNext: onNext,
    cancelClickHandler: cancelClickHandler,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  })));
};
exports.InstallElasticAgentStandalonePageStep = InstallElasticAgentStandalonePageStep;