"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.packageHasAtLeastOneSecret = void 0;
var _services = require("../../../../../../../common/services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const packageHasAtLeastOneSecret = ({
  packageInfo
}) => {
  var _packageInfo$vars;
  if ((_packageInfo$vars = packageInfo.vars) !== null && _packageInfo$vars !== void 0 && _packageInfo$vars.some(v => v.secret)) {
    return true;
  }
  for (const policyTemplate of (_packageInfo$policy_t = packageInfo.policy_templates) !== null && _packageInfo$policy_t !== void 0 ? _packageInfo$policy_t : []) {
    var _packageInfo$policy_t;
    if ((0, _services.isInputOnlyPolicyTemplate)(policyTemplate)) {
      var _policyTemplate$vars;
      if ((_policyTemplate$vars = policyTemplate.vars) !== null && _policyTemplate$vars !== void 0 && _policyTemplate$vars.some(v => v.secret)) {
        return true;
      }
    } else {
      for (const input of (_policyTemplate$input = policyTemplate.inputs) !== null && _policyTemplate$input !== void 0 ? _policyTemplate$input : []) {
        var _policyTemplate$input, _input$vars;
        if ((_input$vars = input.vars) !== null && _input$vars !== void 0 && _input$vars.some(v => v.secret)) {
          return true;
        }
      }
    }
  }
  return false;
};
exports.packageHasAtLeastOneSecret = packageHasAtLeastOneSecret;