"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInputUnitsByPackage = exports.InputStatusFormatter = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class InputStatusFormatter {
  constructor(status, message) {
    (0, _defineProperty2.default)(this, "status", void 0);
    (0, _defineProperty2.default)(this, "description", void 0);
    (0, _defineProperty2.default)(this, "hasError", void 0);
    this.status = status;
    this.description = message || _i18n.i18n.translate('xpack.fleet.agentDetailsIntegrations.inputStatusDefaultDescription', {
      defaultMessage: 'Not available'
    });
    this.hasError = status === 'FAILED' || status === 'DEGRADED';
  }
  getErrorTitleFromStatus() {
    switch (this.status) {
      case 'FAILED':
        return _i18n.i18n.translate('xpack.fleet.agentDetailsIntegrations.inputErrorTitle.failed', {
          defaultMessage: 'Failed'
        });
      case 'DEGRADED':
        return _i18n.i18n.translate('xpack.fleet.agentDetailsIntegrations.inputErrorTitle.degraded', {
          defaultMessage: 'Degraded'
        });
      default:
        return;
    }
  }
}
exports.InputStatusFormatter = InputStatusFormatter;
const getInputUnitsByPackage = (agentComponents, packagePolicy) => {
  const re = new RegExp(packagePolicy.id);
  return agentComponents.map(c => (c === null || c === void 0 ? void 0 : c.units) || []).flat().filter(u => !!u && u.id.match(re));
};
exports.getInputUnitsByPackage = getInputUnitsByPackage;