"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetUninstallTokens = exports.useGetUninstallToken = exports.sendGetUninstallToken = void 0;
var _reactQuery = require("@kbn/react-query");
var _services = require("../../../common/services");
var _constants = require("../../../common/constants");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetUninstallTokens = (query = {}) => (0, _reactQuery.useQuery)(['useGetUninstallTokens', query], () => (0, _use_request.sendRequestForRq)({
  method: 'get',
  path: _services.uninstallTokensRouteService.getListPath(),
  version: _constants.API_VERSIONS.public.v1,
  query
}));
exports.useGetUninstallTokens = useGetUninstallTokens;
const useGetUninstallToken = uninstallTokenId => (0, _reactQuery.useQuery)(['useGetUninstallToken', uninstallTokenId], () => (0, _use_request.sendRequestForRq)({
  method: 'get',
  path: _services.uninstallTokensRouteService.getInfoPath(uninstallTokenId),
  version: _constants.API_VERSIONS.public.v1
}));
exports.useGetUninstallToken = useGetUninstallToken;
const sendGetUninstallToken = uninstallTokenId => (0, _use_request.sendRequest)({
  method: 'get',
  path: _services.uninstallTokensRouteService.getInfoPath(uninstallTokenId),
  version: _constants.API_VERSIONS.public.v1
});
exports.sendGetUninstallToken = sendGetUninstallToken;