"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.packagePolicyV10OnWriteScanFix = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const packagePolicyV10OnWriteScanFix = packagePolicyDoc => {
  var _packagePolicyDoc$att;
  if (((_packagePolicyDoc$att = packagePolicyDoc.attributes.package) === null || _packagePolicyDoc$att === void 0 ? void 0 : _packagePolicyDoc$att.name) !== 'endpoint') {
    return {
      attributes: packagePolicyDoc.attributes
    };
  }
  const updatedPackagePolicyDoc = packagePolicyDoc;
  const input = updatedPackagePolicyDoc.attributes.inputs[0];
  if (input && input.config) {
    const policy = input.config.policy.value;
    if (policy.windows.malware.mode === 'off') {
      policy.windows.malware.on_write_scan = false;
    }
    if (policy.mac.malware.mode === 'off') {
      policy.mac.malware.on_write_scan = false;
    }
    if (policy.linux.malware.mode === 'off') {
      policy.linux.malware.on_write_scan = false;
    }
  }
  return {
    attributes: updatedPackagePolicyDoc.attributes
  };
};
exports.packagePolicyV10OnWriteScanFix = packagePolicyV10OnWriteScanFix;