"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteFleetServerHostsSecrets = deleteFleetServerHostsSecrets;
exports.extractAndUpdateFleetServerHostsSecrets = extractAndUpdateFleetServerHostsSecrets;
exports.extractAndWriteFleetServerHostsSecrets = extractAndWriteFleetServerHostsSecrets;
exports.getFleetServerHostsSecretReferences = getFleetServerHostsSecretReferences;
var _common = require("./common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function extractAndWriteFleetServerHostsSecrets(opts) {
  const {
    fleetServerHost,
    esClient,
    secretHashes = {}
  } = opts;
  const secretPaths = getFleetServerHostsSecretPaths(fleetServerHost);
  const secretRes = await (0, _common.extractAndWriteSOSecrets)({
    soObject: fleetServerHost,
    secretPaths,
    esClient,
    secretHashes
  });
  return {
    fleetServerHost: secretRes.soObjectWithSecrets,
    secretReferences: secretRes.secretReferences
  };
}
async function extractAndUpdateFleetServerHostsSecrets(opts) {
  const {
    oldFleetServerHost,
    fleetServerHostUpdate,
    esClient,
    secretHashes
  } = opts;
  const oldSecretPaths = getFleetServerHostsSecretPaths(oldFleetServerHost);
  const updatedSecretPaths = getFleetServerHostsSecretPaths(fleetServerHostUpdate);
  const secretsRes = await (0, _common.extractAndUpdateSOSecrets)({
    updatedSoObject: fleetServerHostUpdate,
    oldSecretPaths,
    updatedSecretPaths,
    esClient,
    secretHashes
  });
  return {
    fleetServerHostUpdate: secretsRes.updatedSoObject,
    secretReferences: secretsRes.secretReferences,
    secretsToDelete: secretsRes.secretsToDelete
  };
}
async function deleteFleetServerHostsSecrets(opts) {
  const {
    fleetServerHost,
    esClient
  } = opts;
  const secretPaths = getFleetServerHostsSecretPaths(fleetServerHost);
  await (0, _common.deleteSOSecrets)(esClient, secretPaths);
}
function getFleetServerHostsSecretReferences(fleetServerHost) {
  var _fleetServerHost$secr, _fleetServerHost$secr2, _fleetServerHost$secr3, _fleetServerHost$secr4;
  const secretPaths = [];
  if (typeof ((_fleetServerHost$secr = fleetServerHost.secrets) === null || _fleetServerHost$secr === void 0 ? void 0 : (_fleetServerHost$secr2 = _fleetServerHost$secr.ssl) === null || _fleetServerHost$secr2 === void 0 ? void 0 : _fleetServerHost$secr2.key) === 'object') {
    secretPaths.push({
      id: fleetServerHost.secrets.ssl.key.id
    });
  }
  if (typeof ((_fleetServerHost$secr3 = fleetServerHost.secrets) === null || _fleetServerHost$secr3 === void 0 ? void 0 : (_fleetServerHost$secr4 = _fleetServerHost$secr3.ssl) === null || _fleetServerHost$secr4 === void 0 ? void 0 : _fleetServerHost$secr4.es_key) === 'object') {
    secretPaths.push({
      id: fleetServerHost.secrets.ssl.es_key.id
    });
  }
  return secretPaths;
}
function getFleetServerHostsSecretPaths(fleetServerHost) {
  var _fleetServerHost$secr5, _fleetServerHost$secr6, _fleetServerHost$secr7, _fleetServerHost$secr8;
  const secretPaths = [];
  if (fleetServerHost !== null && fleetServerHost !== void 0 && (_fleetServerHost$secr5 = fleetServerHost.secrets) !== null && _fleetServerHost$secr5 !== void 0 && (_fleetServerHost$secr6 = _fleetServerHost$secr5.ssl) !== null && _fleetServerHost$secr6 !== void 0 && _fleetServerHost$secr6.key) {
    secretPaths.push({
      path: 'secrets.ssl.key',
      value: fleetServerHost.secrets.ssl.key
    });
  }
  if (fleetServerHost !== null && fleetServerHost !== void 0 && (_fleetServerHost$secr7 = fleetServerHost.secrets) !== null && _fleetServerHost$secr7 !== void 0 && (_fleetServerHost$secr8 = _fleetServerHost$secr7.ssl) !== null && _fleetServerHost$secr8 !== void 0 && _fleetServerHost$secr8.es_key) {
    secretPaths.push({
      path: 'secrets.ssl.es_key',
      value: fleetServerHost.secrets.ssl.es_key
    });
  }
  return secretPaths;
}