"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.graphWorkspace = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _migrations = require("./migrations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const graphWorkspace = exports.graphWorkspace = {
  name: 'graph-workspace',
  indexPattern: _coreSavedObjectsServer.ANALYTICS_SAVED_OBJECT_INDEX,
  namespaceType: 'multiple-isolated',
  convertToMultiNamespaceTypeVersion: '8.0.0',
  hidden: false,
  management: {
    icon: 'graphApp',
    defaultSearchField: 'title',
    importableAndExportable: true,
    getTitle(obj) {
      return obj.attributes.title;
    },
    getInAppUrl(obj) {
      return {
        path: `/app/graph#/workspace/${encodeURIComponent(obj.id)}`,
        uiCapabilitiesPath: 'graph.show'
      };
    }
  },
  migrations: _migrations.graphMigrations,
  mappings: {
    properties: {
      description: {
        type: 'text'
      },
      kibanaSavedObjectMeta: {
        properties: {
          searchSourceJSON: {
            type: 'text'
          }
        }
      },
      numLinks: {
        type: 'integer'
      },
      numVertices: {
        type: 'integer'
      },
      title: {
        type: 'text'
      },
      version: {
        type: 'integer'
      },
      wsState: {
        type: 'text'
      },
      legacyIndexPatternRef: {
        type: 'text',
        index: false
      }
    }
  }
};