"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.allowUnsafeEval = allowUnsafeEval;
exports.initData = initData;
exports.isBlock = isBlock;
exports.isDecorator = isDecorator;
exports.noop = noop;
exports.toDecoratorOptions = toDecoratorOptions;
exports.transformLiteralToPath = transformLiteralToPath;
var _utils = require("handlebars/dist/cjs/handlebars/utils");
/*
 * Elasticsearch B.V licenses this file to you under the MIT License.
 * See `src/platform/packages/private/kbn-handlebars/LICENSE` for more information.
 */

// @ts-expect-error: Could not find a declaration file for module

function isBlock(node) {
  return 'program' in node || 'inverse' in node;
}
function isDecorator(node) {
  return node.type === 'Decorator' || node.type === 'DecoratorBlock';
}
function toDecoratorOptions(options) {
  // There's really no tests/documentation on this, but to match the upstream codebase we'll remove `lookupProperty` from the decorator context
  delete options.lookupProperty;
  return options;
}
function noop() {
  return '';
}

// liftet from handlebars lib/handlebars/runtime.js
function initData(context, data) {
  if (!data || !('root' in data)) {
    data = data ? (0, _utils.createFrame)(data) : {};
    data.root = context;
  }
  return data;
}

// liftet from handlebars lib/handlebars/compiler/compiler.js
function transformLiteralToPath(node) {
  const pathIsLiteral = 'parts' in node.path === false;
  if (pathIsLiteral) {
    const literal = node.path;
    // @ts-expect-error: Not all `hbs.AST.Literal` sub-types has an `original` property, but that's ok, in that case we just want `undefined`
    const original = literal.original;
    // Casting to string here to make false and 0 literal values play nicely with the rest
    // of the system.
    node.path = {
      type: 'PathExpression',
      data: false,
      depth: 0,
      parts: [original + ''],
      original: original + '',
      loc: literal.loc
    };
  }
}
function allowUnsafeEval() {
  try {
    // Do not remove the `kbnUnsafeEvalTest` parameter.
    // It is used for filtering out expected CSP failures, and must be the first piece of content in this function.
    // eslint-disable-next-line no-new-func
    new Function('kbnUnsafeEvalTest', 'return true;');
    return true;
  } catch (e) {
    return false;
  }
}