"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeAttrsDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _api = require("../../../../../../../services/api");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/components/phases/shared_fields/data_tier_allocation_field/components/node_attrs_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NodeAttrsDetails = ({
  close,
  selectedNodeAttrs
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    data,
    isLoading,
    error,
    resendRequest
  } = (0, _api.useLoadNodeDetails)(selectedNodeAttrs);
  let content;
  if (isLoading) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 3,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 15
      }
    });
  } else if (error) {
    const {
      statusCode,
      message
    } = error;
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.editPolicy.nodeDetailsLoadingFailedTitle",
        defaultMessage: "Unable to load node attribute details",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 44,
          columnNumber: 11
        }
      }),
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 9
      }
    }, message, " (", statusCode, ")"), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: resendRequest,
      iconType: "refresh",
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicy.nodeDetailsReloadButton",
      defaultMessage: "Try again",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 11
      }
    })));
  } else {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      items: data || [],
      columns: [{
        field: 'nodeId',
        name: _i18n.i18n.translate('xpack.indexLifecycleMgmt.nodeAttrDetails.idField', {
          defaultMessage: 'ID'
        })
      }, {
        field: 'stats.name',
        name: _i18n.i18n.translate('xpack.indexLifecycleMgmt.nodeAttrDetails.nameField', {
          defaultMessage: 'Name'
        })
      }, {
        field: 'stats.host',
        name: _i18n.i18n.translate('xpack.indexLifecycleMgmt.nodeAttrDetails.hostField', {
          defaultMessage: 'Host'
        })
      }],
      pagination: true,
      sorting: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: close,
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.nodeAttrDetails.title",
    defaultMessage: "Nodes that contain the attribute {selectedNodeAttrs}",
    values: {
      selectedNodeAttrs
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }), content)));
};
exports.NodeAttrsDetails = NodeAttrsDetails;