"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectInferenceId = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _inferenceCommon = require("@kbn/inference-common");
var _react = _interopRequireWildcard(require("react"));
var _lib = require("../../../lib");
var _app_context = require("../../../../../app_context");
var _api = require("../../../../../services/api");
var _shared_imports = require("../../../shared_imports");
var _ml_vcu_usage_cost_tour = require("./ml_vcu_usage_cost_tour");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/field_parameters/select_inference_id.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const InferenceFlyoutWrapper = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/inference-endpoint-ui-common'))));
const SelectInferenceId = ({
  'data-test-subj': dataTestSubj
}) => {
  const config = (0, _lib.getFieldConfig)('inference_id');
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "inference_id",
    fieldConfig: config,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, field => {
    return /*#__PURE__*/_react.default.createElement(SelectInferenceIdContent, {
      "data-test-subj": dataTestSubj,
      value: field.value,
      setValue: field.setValue,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 11
      }
    });
  });
};
exports.SelectInferenceId = SelectInferenceId;
const SelectInferenceIdContent = ({
  'data-test-subj': dataTestSubj,
  setValue,
  value
}) => {
  var _share$url$locators$g, _options$find;
  const {
    core: {
      application,
      http
    },
    config: {
      enforceAdaptiveAllocations
    },
    services: {
      notificationService: {
        toasts
      }
    },
    docLinks,
    plugins: {
      cloud,
      share
    }
  } = (0, _app_context.useAppContext)();
  const config = (0, _lib.getFieldConfig)('inference_id');
  const inferenceEndpointsPageLink = share === null || share === void 0 ? void 0 : (_share$url$locators$g = share.url.locators.get('SEARCH_INFERENCE_ENDPOINTS')) === null || _share$url$locators$g === void 0 ? void 0 : _share$url$locators$g.useUrl({});
  const [isInferenceFlyoutVisible, setIsInferenceFlyoutVisible] = (0, _react.useState)(false);
  const onFlyoutClose = (0, _react.useCallback)(() => {
    setIsInferenceFlyoutVisible(!isInferenceFlyoutVisible);
  }, [isInferenceFlyoutVisible]);
  const {
    isLoading,
    data: endpoints,
    resendRequest
  } = (0, _api.useLoadInferenceEndpoints)();
  const onSubmitSuccess = (0, _react.useCallback)(newEndpointId => {
    resendRequest();
    setValue(newEndpointId);
  }, [resendRequest, setValue]);
  const options = (0, _react.useMemo)(() => {
    const filteredEndpoints = endpoints === null || endpoints === void 0 ? void 0 : endpoints.filter(endpoint => endpoint.task_type === 'text_embedding' || endpoint.task_type === 'sparse_embedding');
    const newOptions = [...(filteredEndpoints || [])].map(endpoint => ({
      label: endpoint.inference_id,
      'data-test-subj': `custom-inference_${endpoint.inference_id}`,
      checked: value === endpoint.inference_id ? 'on' : undefined
    }));
    /**
     * Adding this check to ensure we have the preconfigured elser endpoint selected by default.
     */
    const hasInferenceSelected = newOptions.some(option => option.checked === 'on');
    // If nothing has been selected, select .elser-2-elasticsearch as default if it exists.
    // Use a constant for the ELSER inference endpoint label instead of a hard-coded string

    if (!hasInferenceSelected && newOptions.length > 0) {
      const elserOption = newOptions.find(option => option.label === _inferenceCommon.defaultInferenceEndpoints.ELSER);
      if (elserOption) {
        elserOption.checked = 'on';
        if (!value) {
          setValue(_inferenceCommon.defaultInferenceEndpoints.ELSER);
        }
      } else {
        // fallback: select the first option if the Elser option does not exist
        // This line uses array destructuring to select the first element from newOptions array.
        // `firstOption` will be assigned the first option object from newOptions, or undefined if the array is empty.
        const firstOption = newOptions[0];
        if (firstOption) {
          firstOption.checked = 'on';
          if (!value) {
            setValue(firstOption.label);
          }
        }
      }
    }
    if (value && !newOptions.find(option => option.label === value)) {
      // Sometimes we create a new endpoint but the backend is slow in updating so we need to optimistically update
      const newOption = {
        label: value,
        checked: 'on',
        'data-test-subj': `custom-inference_${value}`
      };
      return [...newOptions, newOption];
    }
    return newOptions;
  }, [endpoints, value, setValue]);
  const [isInferencePopoverVisible, setIsInferencePopoverVisible] = (0, _react.useState)(false);
  const selectedOptionLabel = (_options$find = options.find(option => option.checked)) === null || _options$find === void 0 ? void 0 : _options$find.label;
  const inferencePopover = () => /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 15
      }
    }, config.label))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "arrowDown",
      iconSide: "right",
      color: "text",
      "data-test-subj": "inferenceIdButton",
      onClick: () => {
        setIsInferencePopoverVisible(!isInferencePopoverVisible);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 11
      }
    }, selectedOptionLabel || _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.alreadyExistsLabel', {
      defaultMessage: 'No inference endpoint selected'
    }))),
    isOpen: isInferencePopoverVisible,
    panelPaddingSize: "none",
    closePopover: () => setIsInferencePopoverVisible(!isInferencePopoverVisible),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "createInferenceEndpointButton",
    icon: "plusInCircle",
    size: "s",
    "data-test-subj": "createInferenceEndpointButton",
    onClick: e => {
      e.preventDefault();
      setIsInferenceFlyoutVisible(true);
      setIsInferencePopoverVisible(!isInferencePopoverVisible);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.createInferenceEndpointButton', {
    defaultMessage: 'Add inference endpoint'
  })), inferenceEndpointsPageLink && /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "manageInferenceEndpointButton",
    icon: "gear",
    size: "s",
    "data-test-subj": "manageInferenceEndpointButton",
    href: inferenceEndpointsPageLink,
    onClick: e => {
      e.preventDefault();
      application.navigateToUrl(inferenceEndpointsPageLink);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.manageInferenceEndpointButton', {
    defaultMessage: 'Manage Inference Endpoints'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.selectable.Label', {
      defaultMessage: 'Existing endpoints'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.selectable.ariaLabel', {
      defaultMessage: 'Existing endpoints'
    }),
    "data-test-subj": dataTestSubj,
    searchable: true,
    isLoading: isLoading,
    singleSelection: "always",
    defaultChecked: true,
    searchProps: {
      compressed: true,
      placeholder: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.selectable.placeholder', {
        defaultMessage: 'Search'
      })
    },
    options: options,
    onChange: newOptions => {
      var _newOptions$find;
      setValue(((_newOptions$find = newOptions.find(option => option.checked)) === null || _newOptions$find === void 0 ? void 0 : _newOptions$find.label) || '');
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 13
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 19
    }
  }), list))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "question",
      color: "primary",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 278,
        columnNumber: 33
      }
    }),
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.inferenceManagement.inferenceAPIDocumentation,
    target: "_blank",
    "data-test-subj": "learn-how-to-create-inference-endpoints",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.learnHowToCreateInferenceEndpoints', {
    defaultMessage: 'Learn how to create inference endpoints'
  }))));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "selectInferenceId",
    alignItems: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 9
    }
  }, cloud !== null && cloud !== void 0 && cloud.isServerlessEnabled ? /*#__PURE__*/_react.default.createElement(_ml_vcu_usage_cost_tour.MlVcuUsageCostTour, {
    children: inferencePopover(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 13
    }
  }) : inferencePopover(), isInferenceFlyoutVisible ? /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 306,
        columnNumber: 33
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(InferenceFlyoutWrapper, {
    onFlyoutClose: onFlyoutClose,
    http: http,
    toasts: toasts,
    isEdit: false,
    onSubmitSuccess: onSubmitSuccess,
    enforceAdaptiveAllocations: enforceAdaptiveAllocations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 15
    }
  })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 321,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.noReferenceModelStartWarningMessage', {
    defaultMessage: 'The referenced model for this inference endpoint will be started when adding this field.'
  })))))));
};