"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.indexModeLabels = exports.indexModeDescriptions = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const indexModeLabels = exports.indexModeLabels = {
  [_constants.STANDARD_INDEX_MODE]: _i18n.i18n.translate('xpack.idxMgmt.indexModeLabels.standardIndexModeLabel', {
    defaultMessage: 'Standard'
  }),
  [_constants.LOGSDB_INDEX_MODE]: _i18n.i18n.translate('xpack.idxMgmt.indexModeLabels.logsdbIndexModeLabel', {
    defaultMessage: 'LogsDB'
  }),
  [_constants.TIME_SERIES_MODE]: _i18n.i18n.translate('xpack.idxMgmt.indexModeLabels.timeSeriesIndexModeLabel', {
    defaultMessage: 'Time series'
  }),
  [_constants.LOOKUP_INDEX_MODE]: _i18n.i18n.translate('xpack.idxMgmt.indexModeLabels.lookupIndexModeLabel', {
    defaultMessage: 'Lookup'
  })
};
const indexModeDescriptions = exports.indexModeDescriptions = {
  [_constants.STANDARD_INDEX_MODE]: _i18n.i18n.translate('xpack.idxMgmt.indexModeDescriptions.standardIndexModeDescription', {
    defaultMessage: 'Standard indexing with default settings, for data other than logs or metrics.'
  }),
  [_constants.LOGSDB_INDEX_MODE]: _i18n.i18n.translate('xpack.idxMgmt.indexModeDescriptions.logsdbIndexModeDescription', {
    defaultMessage: 'Optimized for storing logs data, with reduced storage and default settings that help reduce the chance of logs being rejected by Elasticsearch.'
  }),
  [_constants.TIME_SERIES_MODE]: _i18n.i18n.translate('xpack.idxMgmt.indexModeDescriptions.timeSeriesIndexModeDescription', {
    defaultMessage: 'Optimized for metrics data with reduced storage.'
  }),
  [_constants.LOOKUP_INDEX_MODE]: _i18n.i18n.translate('xpack.idxMgmt.indexModeDescriptions.lookupIndexModeDescription', {
    defaultMessage: 'Optimized for ES|QL join operations.'
  })
};