"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TemplateTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _analytics = require("@kbn/analytics");
var _eui = require("@elastic/eui");
var _sharedUxTablePersist = require("@kbn/shared-ux-table-persist");
var _constants = require("../../../../../../common/constants");
var _shared_imports = require("../../../../../shared_imports");
var _app_context = require("../../../../app_context");
var _components = require("../../../../components");
var _shared = require("../../../../components/shared");
var _routing = require("../../../../services/routing");
var _components2 = require("../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/template_list/template_table/template_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PAGE_SIZE_OPTIONS = [10, 20, 50];
const TemplateTable = ({
  templates,
  reload,
  editTemplate,
  cloneTemplate,
  history
}) => {
  const {
    uiMetricService
  } = (0, _app_context.useServices)();
  const [selection, setSelection] = (0, _react.useState)([]);
  const [templatesToDelete, setTemplatesToDelete] = (0, _react.useState)([]);
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.idxMgmt.templateList.table.nameColumnTitle', {
      defaultMessage: 'Name'
    }),
    sortable: true,
    width: '30%',
    render: (name, item) => {
      return /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, (0, _shared_imports.reactRouterNavigate)(history, (0, _routing.getTemplateDetailsLink)(name), () => uiMetricService.trackMetric(_analytics.METRIC_TYPE.CLICK, _constants.UIM_TEMPLATE_SHOW_DETAILS_CLICK)), {
        role: "button",
        "data-test-subj": "templateDetailsLink",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 61,
          columnNumber: 13
        }
      }), name), ' ', item.deprecated && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement(_components2.TemplateDeprecatedBadge, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 17
        }
      })), "\xA0", /*#__PURE__*/_react.default.createElement(_components2.TemplateTypeIndicator, {
        templateType: item._kbnMeta.type,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 77,
          columnNumber: 13
        }
      }));
    }
  }, {
    field: 'indexPatterns',
    name: _i18n.i18n.translate('xpack.idxMgmt.templateList.table.indexPatternsColumnTitle', {
      defaultMessage: 'Index patterns'
    }),
    sortable: true,
    width: '20%',
    render: indexPatterns => /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 44
      }
    }, indexPatterns.join(', '))
  }, {
    field: 'composedOf',
    name: _i18n.i18n.translate('xpack.idxMgmt.templateList.table.componentsColumnTitle', {
      defaultMessage: 'Component templates'
    }),
    width: '100px',
    truncateText: true,
    sortable: template => {
      var _template$composedOf;
      return (_template$composedOf = template.composedOf) === null || _template$composedOf === void 0 ? void 0 : _template$composedOf.length;
    },
    render: (composedOf = [], item) => composedOf.length === 0 ? /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 11
      }
    }, "0") : /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
      "data-test-subj": "componentTemplatesLink"
    }, (0, _shared_imports.reactRouterNavigate)(history, (0, _routing.getComponentTemplatesLink)(item.name)), {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 11
      }
    }), composedOf.length)
  }, {
    name: _i18n.i18n.translate('xpack.idxMgmt.templateList.table.dataStreamColumnTitle', {
      defaultMessage: 'Data stream'
    }),
    width: '90px',
    align: 'center',
    truncateText: true,
    render: template => template._kbnMeta.hasDatastream ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "check",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 43
      }
    }) : null
  }, {
    name: _i18n.i18n.translate('xpack.idxMgmt.templateList.table.contentColumnTitle', {
      defaultMessage: 'Content'
    }),
    width: '120px',
    render: item => /*#__PURE__*/_react.default.createElement(_shared.TemplateContentIndicator, {
      mappings: item.hasMappings,
      settings: item.hasSettings,
      aliases: item.hasAliases,
      contentWhenEmpty: /*#__PURE__*/_react.default.createElement("em", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 134,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('xpack.idxMgmt.templateList.table.noneDescriptionText', {
        defaultMessage: 'None'
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 9
      }
    })
  }, {
    name: _i18n.i18n.translate('xpack.idxMgmt.templateList.table.actionColumnTitle', {
      defaultMessage: 'Actions'
    }),
    width: '120px',
    actions: [{
      name: _i18n.i18n.translate('xpack.idxMgmt.templateList.table.actionEditText', {
        defaultMessage: 'Edit'
      }),
      isPrimary: true,
      description: _i18n.i18n.translate('xpack.idxMgmt.templateList.table.actionEditDecription', {
        defaultMessage: 'Edit this template'
      }),
      icon: 'pencil',
      type: 'icon',
      onClick: ({
        name
      }) => {
        editTemplate(name);
      },
      enabled: ({
        _kbnMeta: {
          type
        }
      }) => type !== 'cloudManaged'
    }, {
      type: 'icon',
      name: _i18n.i18n.translate('xpack.idxMgmt.templateList.table.actionCloneTitle', {
        defaultMessage: 'Clone'
      }),
      description: _i18n.i18n.translate('xpack.idxMgmt.templateList.table.actionCloneDescription', {
        defaultMessage: 'Clone this template'
      }),
      icon: 'copy',
      onClick: ({
        name
      }) => {
        cloneTemplate(name);
      }
    }, {
      name: _i18n.i18n.translate('xpack.idxMgmt.templateList.table.actionDeleteText', {
        defaultMessage: 'Delete'
      }),
      description: _i18n.i18n.translate('xpack.idxMgmt.templateList.table.actionDeleteDecription', {
        defaultMessage: 'Delete this template'
      }),
      icon: 'trash',
      color: 'danger',
      type: 'icon',
      onClick: ({
        name,
        _kbnMeta: {
          isLegacy,
          type
        }
      }) => {
        setTemplatesToDelete([{
          name,
          isLegacy,
          type
        }]);
      },
      isPrimary: true,
      enabled: ({
        _kbnMeta: {
          type
        }
      }) => type !== 'cloudManaged'
    }]
  }];
  const {
    pageSize,
    sorting,
    onTableChange
  } = (0, _sharedUxTablePersist.useEuiTablePersist)({
    tableId: 'indexTemplates',
    initialPageSize: 20,
    initialSort: {
      field: 'name',
      direction: 'asc'
    },
    pageSizeOptions: PAGE_SIZE_OPTIONS
  });
  const pagination = {
    pageSize,
    pageSizeOptions: PAGE_SIZE_OPTIONS
  };
  const selectionConfig = {
    onSelectionChange: setSelection,
    selectable: ({
      _kbnMeta: {
        type
      }
    }) => type !== 'cloudManaged',
    selectableMessage: selectable => {
      if (!selectable) {
        return _i18n.i18n.translate('xpack.idxMgmt.templateList.table.deleteCloudManagedTemplateTooltip', {
          defaultMessage: 'You cannot delete a cloud-managed template.'
        });
      }
      return '';
    }
  };
  const searchConfig = {
    box: {
      incremental: true
    },
    toolsLeft: selection.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "deleteTemplatesButton",
      onClick: () => setTemplatesToDelete(selection.map(({
        name,
        _kbnMeta: {
          isLegacy,
          type
        }
      }) => ({
        name,
        isLegacy,
        type
      }))),
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.templateList.table.deleteTemplatesButtonLabel",
      defaultMessage: "Delete {count, plural, one {template} other {templates} }",
      values: {
        count: selection.length
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 247,
        columnNumber: 11
      }
    })) : undefined,
    toolsRight: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
      iconType: "plusInCircle",
      "data-test-subj": "createTemplateButton",
      key: "createTemplateButton",
      fill: true
    }, (0, _shared_imports.reactRouterNavigate)(history, '/create_template'), {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 255,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.templateList.table.createTemplatesButtonLabel",
      defaultMessage: "Create template",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 262,
        columnNumber: 9
      }
    }))]
  };
  const goToList = () => {
    return history.push('templates');
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 5
    }
  }, templatesToDelete && templatesToDelete.length > 0 ? /*#__PURE__*/_react.default.createElement(_components.TemplateDeleteModal, {
    callback: data => {
      if (data && data.hasDeletedTemplates) {
        reload();
        // Close the flyout if it is opened
        goToList();
      }
      setTemplatesToDelete([]);
    },
    templatesToDelete: templatesToDelete,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 9
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: templates || [],
    itemId: "name",
    columns: columns,
    search: searchConfig,
    sorting: sorting,
    selection: selectionConfig,
    pagination: pagination,
    onTableChange: onTableChange,
    rowProps: () => ({
      'data-test-subj': 'row'
    }),
    cellProps: () => ({
      'data-test-subj': 'cell'
    }),
    "data-test-subj": "templateTable",
    message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.templateList.table.noIndexTemplatesMessage",
      defaultMessage: "No index templates found",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 306,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 7
    }
  }));
};
exports.TemplateTable = TemplateTable;