"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createObservableFromHttpResponse = createObservableFromHttpResponse;
var _eventsourceParser = require("eventsource-parser");
var _rxjs = require("rxjs");
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createObservableFromHttpResponse(response) {
  const rawResponse = response.response;
  const body = rawResponse === null || rawResponse === void 0 ? void 0 : rawResponse.body;
  if (!body) {
    return (0, _rxjs.throwError)(() => {
      throw (0, _inferenceCommon.createInferenceInternalError)(`No readable stream found in response`);
    });
  }
  return new _rxjs.Observable(subscriber => {
    const parser = (0, _eventsourceParser.createParser)({
      onEvent: event => {
        subscriber.next(event.data);
      }
    });
    const readStream = async () => {
      const reader = body.getReader();
      const decoder = new TextDecoder();

      // Function to process each chunk
      const processChunk = ({
        done,
        value
      }) => {
        if (done) {
          return Promise.resolve();
        }
        parser.feed(decoder.decode(value, {
          stream: true
        }));
        return reader.read().then(processChunk);
      };

      // Start reading the stream
      return reader.read().then(processChunk);
    };
    readStream().then(() => {
      subscriber.complete();
    }).catch(error => {
      subscriber.error(error);
    });
  });
}