"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tokensEvent = exports.messageEvent = exports.chunkEvent = void 0;
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const chunkEvent = (content = 'chunk', toolCalls = []) => ({
  type: _inferenceCommon.ChatCompletionEventType.ChatCompletionChunk,
  content,
  tool_calls: toolCalls
});
exports.chunkEvent = chunkEvent;
const messageEvent = (content = 'message', toolCalls = []) => ({
  type: _inferenceCommon.ChatCompletionEventType.ChatCompletionMessage,
  content,
  toolCalls
});
exports.messageEvent = messageEvent;
const tokensEvent = tokens => {
  var _tokens$prompt, _tokens$completion, _tokens$total;
  return {
    type: _inferenceCommon.ChatCompletionEventType.ChatCompletionTokenCount,
    tokens: {
      prompt: (_tokens$prompt = tokens === null || tokens === void 0 ? void 0 : tokens.prompt) !== null && _tokens$prompt !== void 0 ? _tokens$prompt : 10,
      completion: (_tokens$completion = tokens === null || tokens === void 0 ? void 0 : tokens.completion) !== null && _tokens$completion !== void 0 ? _tokens$completion : 20,
      total: (_tokens$total = tokens === null || tokens === void 0 ? void 0 : tokens.total) !== null && _tokens$total !== void 0 ? _tokens$total : 30
    }
  };
};
exports.tokensEvent = tokensEvent;