"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogEntryCategoriesQuality = void 0;
var _react = require("react");
var _useDeepCompareEffect = _interopRequireDefault(require("react-use/lib/useDeepCompareEffect"));
var _use_kibana = require("../../../../../hooks/use_kibana");
var _use_tracked_promise = require("../../../../../hooks/use_tracked_promise");
var _get_latest_categories_datasets_stats = require("../../api/get_latest_categories_datasets_stats");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogEntryCategoriesQuality = ({
  jobSummaries
}) => {
  const {
    services: {
      http: {
        fetch
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [lastestWarnedDatasetsStats, setLatestWarnedDatasetsStats] = (0, _react.useState)([]);
  const jobSummariesWithCategoryWarnings = (0, _react.useMemo)(() => jobSummaries.filter(isJobWithCategoryWarnings), [jobSummaries]);
  const jobSummariesWithPartitionedCategoryWarnings = (0, _react.useMemo)(() => jobSummariesWithCategoryWarnings.filter(isJobWithPartitionedCategories), [jobSummariesWithCategoryWarnings]);
  const [fetchLatestWarnedDatasetsStatsRequest, fetchLatestWarnedDatasetsStats] = (0, _use_tracked_promise.useTrackedPromise)({
    cancelPreviousOn: 'creation',
    createPromise: statsIntervals => Promise.all(statsIntervals.map(({
      jobId,
      startTime,
      endTime
    }) => (0, _get_latest_categories_datasets_stats.callGetLatestCategoriesDatasetsStatsAPI)({
      jobIds: [jobId],
      startTime,
      endTime,
      includeCategorizerStatuses: ['warn']
    }, fetch))),
    onResolve: results => {
      setLatestWarnedDatasetsStats(results.flatMap(({
        data: {
          datasetStats
        }
      }) => datasetStats));
    }
  }, []);
  (0, _useDeepCompareEffect.default)(() => {
    fetchLatestWarnedDatasetsStats(jobSummariesWithPartitionedCategoryWarnings.map(jobSummary => {
      var _jobSummary$fullJob$c, _jobSummary$fullJob, _jobSummary$fullJob$m, _jobSummary$fullJob2, _jobSummary$fullJob2$;
      return {
        jobId: jobSummary.id,
        startTime: (_jobSummary$fullJob$c = (_jobSummary$fullJob = jobSummary.fullJob) === null || _jobSummary$fullJob === void 0 ? void 0 : _jobSummary$fullJob.create_time) !== null && _jobSummary$fullJob$c !== void 0 ? _jobSummary$fullJob$c : 0,
        endTime: (_jobSummary$fullJob$m = (_jobSummary$fullJob2 = jobSummary.fullJob) === null || _jobSummary$fullJob2 === void 0 ? void 0 : (_jobSummary$fullJob2$ = _jobSummary$fullJob2.model_size_stats) === null || _jobSummary$fullJob2$ === void 0 ? void 0 : _jobSummary$fullJob2$.log_time) !== null && _jobSummary$fullJob$m !== void 0 ? _jobSummary$fullJob$m : Date.now()
      };
    }));
  }, [jobSummariesWithPartitionedCategoryWarnings]);
  const categoryQualityWarnings = (0, _react.useMemo)(() => [...jobSummariesWithCategoryWarnings.filter(jobSummary => !isJobWithPartitionedCategories(jobSummary)).map(jobSummary => {
    var _jobSummary$fullJob3;
    return {
      type: 'categoryQualityWarning',
      jobId: jobSummary.id,
      dataset: '',
      reasons: (_jobSummary$fullJob3 = jobSummary.fullJob) !== null && _jobSummary$fullJob3 !== void 0 && _jobSummary$fullJob3.model_size_stats ? getCategoryQualityWarningReasons(jobSummary.fullJob.model_size_stats) : []
    };
  }), ...lastestWarnedDatasetsStats.map(datasetStats => ({
    type: 'categoryQualityWarning',
    jobId: datasetStats.job_id,
    dataset: datasetStats.dataset,
    reasons: getCategoryQualityWarningReasons(datasetStats)
  }))], [jobSummariesWithCategoryWarnings, lastestWarnedDatasetsStats]);
  return {
    categoryQualityWarnings,
    lastLatestWarnedDatasetsStatsRequestErrors: fetchLatestWarnedDatasetsStatsRequest.state === 'rejected' ? fetchLatestWarnedDatasetsStatsRequest.value : null,
    isLoadingCategoryQualityWarnings: fetchLatestWarnedDatasetsStatsRequest.state === 'pending'
  };
};
exports.useLogEntryCategoriesQuality = useLogEntryCategoriesQuality;
const isJobWithCategoryWarnings = jobSummary => {
  var _jobSummary$fullJob4, _jobSummary$fullJob4$;
  return ((_jobSummary$fullJob4 = jobSummary.fullJob) === null || _jobSummary$fullJob4 === void 0 ? void 0 : (_jobSummary$fullJob4$ = _jobSummary$fullJob4.model_size_stats) === null || _jobSummary$fullJob4$ === void 0 ? void 0 : _jobSummary$fullJob4$.categorization_status) === 'warn';
};
const isJobWithPartitionedCategories = jobSummary => {
  var _jobSummary$fullJob$a, _jobSummary$fullJob5, _jobSummary$fullJob5$;
  return (_jobSummary$fullJob$a = (_jobSummary$fullJob5 = jobSummary.fullJob) === null || _jobSummary$fullJob5 === void 0 ? void 0 : (_jobSummary$fullJob5$ = _jobSummary$fullJob5.analysis_config) === null || _jobSummary$fullJob5$ === void 0 ? void 0 : _jobSummary$fullJob5$.per_partition_categorization) !== null && _jobSummary$fullJob$a !== void 0 ? _jobSummary$fullJob$a : false;
};
const getCategoryQualityWarningReasons = ({
  categorized_doc_count: categorizedDocCount,
  dead_category_count: deadCategoryCount,
  frequent_category_count: frequentCategoryCount,
  rare_category_count: rareCategoryCount,
  total_category_count: totalCategoryCount
}) => {
  const rareCategoriesRatio = rareCategoryCount / totalCategoryCount;
  const categoriesDocumentRatio = totalCategoryCount / categorizedDocCount;
  const deadCategoriesRatio = deadCategoryCount / totalCategoryCount;
  return [...(totalCategoryCount === 1 ? [{
    type: 'singleCategory'
  }] : []), ...(rareCategoriesRatio >= 0.9 ? [{
    type: 'manyRareCategories',
    rareCategoriesRatio
  }] : []), ...(categorizedDocCount > 100 && categoriesDocumentRatio >= 0.5 ? [{
    type: 'manyCategories',
    categoriesDocumentRatio
  }] : []), ...(frequentCategoryCount === 0 ? [{
    type: 'noFrequentCategories'
  }] : []), ...(deadCategoriesRatio >= 0.5 ? [{
    type: 'manyDeadCategories',
    deadCategoriesRatio
  }] : [])];
};