"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInfraAlertsClient = getInfraAlertsClient;
var _lodash = require("lodash");
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getInfraAlertsClient({
  libs,
  request
}) {
  const [, {
    ruleRegistry
  }] = await libs.getStartServices();
  const alertsClient = await ruleRegistry.getRacClientWithRequest(request);
  const infraAlertsIndices = await alertsClient.getAuthorizedAlertsIndices(_ruleDataUtils.OBSERVABILITY_RULE_TYPE_IDS);
  if (!infraAlertsIndices || (0, _lodash.isEmpty)(infraAlertsIndices)) {
    throw Error('No alert indices exist for "infrastructure"');
  }
  return {
    search(searchParams) {
      return alertsClient.find({
        ...searchParams,
        index: infraAlertsIndices.join(',')
      });
    }
  };
}