"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInfraMetricsClient = getInfraMetricsClient;
var _ui_settings_keys = require("@kbn/observability-plugin/common/ui_settings_keys");
var _exclude_tiers_query = require("@kbn/observability-utils-common/es/queries/exclude_tiers_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getInfraMetricsClient({
  libs,
  context,
  request
}) {
  const {
    framework
  } = libs;
  const infraContext = await context.infra;
  const {
    uiSettings
  } = await context.core;
  const excludedDataTiers = await uiSettings.client.get(_ui_settings_keys.searchExcludedDataTiers);
  const metricsIndices = await infraContext.getMetricsIndices();
  const excludedQuery = excludedDataTiers.length ? (0, _exclude_tiers_query.excludeTiersQuery)(excludedDataTiers) : undefined;
  return {
    search(searchParams) {
      return framework.callWithRequest(context, 'search', {
        ...searchParams,
        ignore_unavailable: true,
        index: metricsIndices,
        query: {
          bool: {
            filter: excludedQuery,
            must: [searchParams.query]
          }
        }
      }, request);
    },
    msearch(searchParams) {
      const searches = searchParams.map(params => {
        const search = [{
          index: metricsIndices,
          preference: 'any',
          ignore_unavailable: true,
          expand_wildcards: ['open', 'hidden']
        }, {
          ...params,
          query: {
            bool: {
              filter: [params.query, ...(excludedQuery ? excludedQuery : [])].filter(Boolean)
            }
          }
        }];
        return search;
      }).flat();
      return framework.callWithRequest(context, 'msearch', {
        searches
      }, request);
    }
  };
}