"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModalProvider = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../shared_imports");
var _deserialize = require("../../deserialize");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/load_from_json/modal_provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const i18nTexts = {
  modalTitle: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.loadFromJson.modalTitle', {
    defaultMessage: 'Load JSON'
  }),
  buttons: {
    cancel: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.loadFromJson.buttons.cancel', {
      defaultMessage: 'Cancel'
    }),
    confirm: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.loadFromJson.buttons.confirm', {
      defaultMessage: 'Load and overwrite'
    })
  },
  editor: {
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.loadFromJson.editor', {
      defaultMessage: 'Pipeline object'
    })
  },
  error: {
    title: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.loadFromJson.error.title', {
      defaultMessage: 'Invalid pipeline'
    }),
    body: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.loadFromJson.error.body', {
      defaultMessage: 'Please ensure the JSON is a valid pipeline object.'
    })
  }
};
const defaultValue = {};
const defaultValueRaw = JSON.stringify(defaultValue, null, 2);
const ModalProvider = ({
  onDone,
  children
}) => {
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const [isValidJson, setIsValidJson] = (0, _react.useState)(true);
  const [error, setError] = (0, _react.useState)();
  const jsonContent = (0, _react.useRef)({
    isValid: true,
    validate: () => true,
    data: {
      format: () => defaultValue,
      raw: defaultValueRaw
    }
  });
  const onJsonUpdate = (0, _react.useCallback)(jsonUpdateData => {
    setIsValidJson(jsonUpdateData.validate());
    jsonContent.current = jsonUpdateData;
  }, []);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children(() => setIsModalVisible(true)), isModalVisible ? /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    "data-test-subj": "loadJsonConfirmationModal",
    title: i18nTexts.modalTitle,
    onCancel: () => {
      setIsModalVisible(false);
    },
    titleProps: {
      id: modalTitleId
    },
    onConfirm: async () => {
      try {
        const json = jsonContent.current.data.format();
        const {
          processors,
          on_failure: onFailure
        } = json;
        // This function will throw if it cannot parse the pipeline object
        (0, _deserialize.deserialize)({
          processors,
          onFailure
        });
        onDone(json);
        setIsModalVisible(false);
      } catch (e) {
        setError(e);
      }
    },
    cancelButtonText: i18nTexts.buttons.cancel,
    confirmButtonDisabled: !isValidJson,
    confirmButtonText: i18nTexts.buttons.confirm,
    maxWidth: 600,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "application",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.pipelineEditor.loadJsonModal.jsonEditorHelpText",
    defaultMessage: "Provide a pipeline object. This will override the existing pipeline processors and on-failure processors.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 13
    }
  }), error && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "errorCallOut",
    title: i18nTexts.error.title,
    color: "danger",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 17
    }
  }, i18nTexts.error.body), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_shared_imports.JsonEditor, {
    label: i18nTexts.editor.label,
    onUpdate: onJsonUpdate,
    codeEditorProps: {
      height: '300px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 13
    }
  }))) : undefined);
};
exports.ModalProvider = ModalProvider;