"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePipelineProcessorsContext = exports.PipelineProcessorsContextProvider = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _processors_reducer = require("../processors_reducer");
var _deserialize = require("../deserialize");
var _serialize = require("../serialize");
var _components = require("../components");
var _utils = require("../utils");
var _test_pipeline_context = require("./test_pipeline_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/context/processors_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PipelineProcessorsContext = /*#__PURE__*/(0, _react.createContext)({});
const PipelineProcessorsContextProvider = ({
  value: {
    processors: originalProcessors,
    onFailure: originalOnFailureProcessors
  },
  onUpdate,
  onFlyoutOpen,
  children
}) => {
  const initRef = (0, _react.useRef)(false);
  const [mode, setMode] = (0, _react.useState)(() => ({
    id: 'idle'
  }));
  const deserializedResult = (0, _react.useMemo)(() => (0, _deserialize.deserialize)({
    processors: originalProcessors,
    onFailure: originalOnFailureProcessors
  }), [originalProcessors, originalOnFailureProcessors]);
  const [processorsState, processorsDispatch] = (0, _processors_reducer.useProcessorsState)(deserializedResult);
  const {
    updateTestOutputPerProcessor,
    testPipelineData
  } = (0, _test_pipeline_context.useTestPipelineContext)();
  const {
    config: {
      documents
    }
  } = testPipelineData;
  (0, _react.useEffect)(() => {
    if (initRef.current) {
      processorsDispatch({
        type: 'loadProcessors',
        payload: {
          newState: deserializedResult
        }
      });
    } else {
      initRef.current = true;
    }
  }, [deserializedResult, processorsDispatch]);
  const {
    onFailure: onFailureProcessors,
    processors
  } = processorsState;
  const [formState, setFormState] = (0, _react.useState)({
    validate: () => Promise.resolve(true)
  });
  const onFormUpdate = (0, _react.useCallback)(({
    isValid,
    validate
  }) => {
    setFormState({
      validate: async () => {
        if (isValid === undefined) {
          return validate();
        }
        return isValid;
      }
    });
  }, [setFormState]);
  (0, _react.useEffect)(() => {
    onUpdate({
      validate: async () => {
        const formValid = await formState.validate();
        return formValid && mode.id === 'idle';
      },
      getData: () => (0, _serialize.serialize)({
        pipeline: {
          onFailure: onFailureProcessors,
          processors
        }
      })
    });
  }, [processors, onFailureProcessors, onUpdate, formState, mode]);
  const onSubmit = (0, _react.useCallback)(processorTypeAndOptions => {
    switch (mode.id) {
      case 'creatingProcessor':
        processorsDispatch({
          type: 'addProcessor',
          payload: {
            processor: {
              ...processorTypeAndOptions
            },
            targetSelector: mode.arg.selector
          }
        });
        break;
      case 'managingProcessor':
        // These are the option names we get back from our UI
        const knownOptionNames = [...Object.keys(processorTypeAndOptions.options),
        // We manually add fields that we **don't** want to be treated as "unknownOptions"
        'internal_networks', 'internal_networks_field', 'value', 'copy_from', 'field', 'keep'];

        // If the processor type is changed while editing, we need to ignore unkownOptions as they
        // will contain the fields from the previous processor resulting in the wrong request.
        const hasProcessorTypeChanged = mode.arg.processor.type !== processorTypeAndOptions.type;
        // The processor that we are updating may have options configured the UI does not know about
        const unknownOptions = hasProcessorTypeChanged ? {} : (0, _lodash.omit)(mode.arg.processor.options, knownOptionNames);
        // In order to keep the options we don't get back from our UI, we merge the known and unknown options
        const updatedProcessorOptions = {
          ...processorTypeAndOptions.options,
          ...unknownOptions
        };
        processorsDispatch({
          type: 'updateProcessor',
          payload: {
            processor: {
              ...mode.arg.processor,
              // Always prefer the newly selected processor type, as it might change during editing
              type: processorTypeAndOptions.type,
              options: updatedProcessorOptions
            },
            selector: mode.arg.selector
          }
        });
        break;
      default:
    }
  }, [processorsDispatch, mode]);
  const onCloseSettingsForm = (0, _react.useCallback)(() => {
    setMode({
      id: 'idle'
    });
    setFormState({
      validate: () => Promise.resolve(true)
    });
  }, [setFormState, setMode]);
  const onTreeAction = (0, _react.useCallback)(action => {
    switch (action.type) {
      case 'addProcessor':
        setMode({
          id: 'creatingProcessor',
          arg: {
            selector: action.payload.target,
            buttonRef: action.payload.buttonRef
          }
        });
        break;
      case 'move':
        setMode({
          id: 'idle'
        });
        processorsDispatch({
          type: 'moveProcessor',
          payload: action.payload
        });
        break;
      case 'selectToMove':
        setMode({
          id: 'movingProcessor',
          arg: action.payload.info
        });
        break;
      case 'cancelMove':
        setMode({
          id: 'idle'
        });
        break;
    }
  }, [processorsDispatch]);

  // Memoize the state object to ensure we do not trigger unnecessary re-renders and so
  // this object can be used safely further down the tree component tree.
  const state = (0, _react.useMemo)(() => {
    return {
      editor: {
        mode,
        setMode
      },
      processors: {
        state: processorsState,
        dispatch: processorsDispatch
      }
    };
  }, [mode, setMode, processorsState, processorsDispatch]);

  // Make a request to the simulate API and update the processor output
  // whenever the documents or processorsState changes (e.g., on move, update, delete)
  (0, _react.useEffect)(() => {
    updateTestOutputPerProcessor(documents, processorsState);
  }, [documents, processorsState, updateTestOutputPerProcessor]);
  return /*#__PURE__*/_react.default.createElement(PipelineProcessorsContext.Provider, {
    value: {
      onTreeAction,
      state
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 5
    }
  }, children, mode.id === 'movingProcessor' && /*#__PURE__*/_react.default.createElement(_components.PipelineProcessorsItemTooltip, {
    processor: (0, _utils.getValue)(mode.arg.selector, {
      processors,
      onFailure: onFailureProcessors
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 9
    }
  }), mode.id === 'managingProcessor' || mode.id === 'creatingProcessor' ? /*#__PURE__*/_react.default.createElement(_components.ProcessorForm, {
    isOnFailure: (0, _processors_reducer.isOnFailureSelector)(mode.arg.selector),
    processor: mode.id === 'managingProcessor' ? mode.arg.processor : undefined,
    buttonRef: mode.arg.buttonRef,
    onOpen: onFlyoutOpen,
    onFormUpdate: onFormUpdate,
    onSubmit: onSubmit,
    onClose: onCloseSettingsForm,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 9
    }
  }) : undefined, mode.id === 'removingProcessor' && /*#__PURE__*/_react.default.createElement(_components.ProcessorRemoveModal, {
    selector: mode.arg.selector,
    processor: (0, _utils.getValue)(mode.arg.selector, {
      processors,
      onFailure: onFailureProcessors
    }),
    onResult: ({
      confirmed,
      selector
    }) => {
      if (confirmed) {
        processorsDispatch({
          type: 'removeProcessor',
          payload: {
            selector
          }
        });
      }
      setMode({
        id: 'idle'
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 9
    }
  }));
};
exports.PipelineProcessorsContextProvider = PipelineProcessorsContextProvider;
const usePipelineProcessorsContext = () => {
  const ctx = (0, _react.useContext)(PipelineProcessorsContext);
  if (!ctx) {
    throw new Error('usePipelineProcessorsContext can only be used inside of PipelineProcessorsContextProvider');
  }
  return ctx;
};
exports.usePipelineProcessorsContext = usePipelineProcessorsContext;