"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InterceptDialogApi = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var Rx = _interopRequireWildcard(require("rxjs"));
var _telemetry = require("./telemetry");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @internal
 */

/**
 * @public
 */

class InterceptDialogApi {
  constructor() {
    (0, _defineProperty2.default)(this, "telemetry", new _telemetry.InterceptTelemetry());
    (0, _defineProperty2.default)(this, "productIntercepts$", new Rx.BehaviorSubject([]));
    (0, _defineProperty2.default)(this, "eventReporter", void 0);
  }
  setup({
    analytics
  }) {
    this.telemetry.setup({
      analytics
    });
    return {};
  }
  start({
    analytics
  }) {
    this.eventReporter = this.telemetry.start({
      analytics
    });
    return {
      add: this.add.bind(this),
      ack: this.ack.bind(this),
      get$: this.get$.bind(this)
    };
  }
  get$() {
    return this.productIntercepts$.asObservable();
  }
  add(productIntercept) {
    const existingIntercepts = this.productIntercepts$.getValue();
    if (existingIntercepts.some(intercept => intercept.id === productIntercept.id)) {
      var _this$eventReporter;
      (_this$eventReporter = this.eventReporter) === null || _this$eventReporter === void 0 ? void 0 : _this$eventReporter.reportInterceptOverload({
        interceptId: productIntercept.id
      });
    } else {
      var _this$eventReporter2;
      // order is important so we can operate on a FIFO basis
      this.productIntercepts$.next([productIntercept, ...existingIntercepts]);
      (_this$eventReporter2 = this.eventReporter) === null || _this$eventReporter2 === void 0 ? void 0 : _this$eventReporter2.reportInterceptRegistration({
        interceptId: productIntercept.id
      });
    }
    return productIntercept.id;
  }

  /**
   * @description expected to be called when a user is determined to have acknowledged the intercept for which the id is provided
   */
  ack({
    interactionDuration,
    interceptId,
    ackType
  }) {
    var _this$eventReporter3;
    this.productIntercepts$.next(this.productIntercepts$.getValue().filter(intercept => intercept.id !== interceptId));
    (_this$eventReporter3 = this.eventReporter) === null || _this$eventReporter3 === void 0 ? void 0 : _this$eventReporter3.reportInterceptInteraction({
      interactionType: ackType,
      interactionDuration,
      interceptId
    });
  }
}
exports.InterceptDialogApi = InterceptDialogApi;