"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createReactOverlays = void 0;
var React = _interopRequireWildcard(require("react"));
var _util = require("../util");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createReactOverlays = services => {
  const checkCoreService = () => {
    if (!services.overlays) {
      throw new TypeError('Could not show overlay as overlays service is not available.');
    }
  };
  const openFlyout = (node, options) => {
    var _services$theme;
    checkCoreService();
    return services.overlays.openFlyout((0, _util.toMountPoint)(/*#__PURE__*/React.createElement(React.Fragment, null, node), {
      theme$: (_services$theme = services.theme) === null || _services$theme === void 0 ? void 0 : _services$theme.theme$
    }), options);
  };
  const openModal = (node, options) => {
    var _services$theme2;
    checkCoreService();
    return services.overlays.openModal((0, _util.toMountPoint)(/*#__PURE__*/React.createElement(React.Fragment, null, node), {
      theme$: (_services$theme2 = services.theme) === null || _services$theme2 === void 0 ? void 0 : _services$theme2.theme$
    }), options);
  };
  const overlays = {
    openFlyout,
    openModal
  };
  return overlays;
};
exports.createReactOverlays = createReactOverlays;