"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerUsageCountersUsageCollector = registerUsageCountersUsageCollector;
exports.toDailyEvents = toDailyEvents;
var _server = require("@kbn/usage-collection-plugin/server");
var _counters = require("../common/counters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const SERVER = 'server';
const SERVER_COUNTERS_FILTER = `${_server.USAGE_COUNTERS_SAVED_OBJECT_TYPE}.attributes.source: ${SERVER}`;
function registerUsageCountersUsageCollector(usageCollection, logger) {
  const collector = usageCollection.makeUsageCollector({
    type: 'usage_counters',
    schema: {
      dailyEvents: {
        type: 'array',
        items: {
          domainId: {
            type: 'keyword',
            _meta: {
              description: 'Domain name of the metric (ie plugin name).'
            }
          },
          counterName: {
            type: 'keyword',
            _meta: {
              description: 'Name of the counter that happened.'
            }
          },
          lastUpdatedAt: {
            type: 'date',
            _meta: {
              description: 'Time at which the metric was last updated.'
            }
          },
          fromTimestamp: {
            type: 'date',
            _meta: {
              description: 'Time at which the metric was captured.'
            }
          },
          counterType: {
            type: 'keyword',
            _meta: {
              description: 'The type of counter used.'
            }
          },
          total: {
            type: 'integer',
            _meta: {
              description: 'The total number of times the event happened.'
            }
          }
        }
      }
    },
    fetch: (0, _counters.createCounterFetcher)(logger, SERVER_COUNTERS_FILTER, toDailyEvents),
    isReady: () => true
  });
  usageCollection.registerCollector(collector);
}
function toDailyEvents(counters) {
  return {
    dailyEvents: counters
  };
}