"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldItemActions = getFieldItemActions;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getFieldItemActions({
  value,
  hasSuggestionForField,
  dropOntoWorkspace,
  closeFieldPopover
}) {
  const canAddToWorkspace = hasSuggestionForField(value);
  const addToWorkplaceButtonTitle = canAddToWorkspace ? _i18n.i18n.translate('xpack.lens.indexPattern.moveToWorkspace', {
    defaultMessage: 'Add {field} to workspace',
    values: {
      field: value.humanData.label
    }
  }) : _i18n.i18n.translate('xpack.lens.indexPattern.moveToWorkspaceNotAvailable', {
    defaultMessage: 'To visualize this field, please add it directly to the desired layer. Adding this field to the workspace is not supported based on your current configuration.'
  });
  const dropOntoWorkspaceAndClose = () => {
    closeFieldPopover === null || closeFieldPopover === void 0 ? void 0 : closeFieldPopover();
    dropOntoWorkspace(value);
  };
  return {
    buttonAddFieldToWorkspaceProps: {
      isDisabled: !canAddToWorkspace,
      'aria-label': addToWorkplaceButtonTitle
    },
    onAddFieldToWorkspace: dropOntoWorkspaceAndClose
  };
}