"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextBasedDimensionEditor = TextBasedDimensionEditor;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _esqlEditor = require("@kbn/esql-editor");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _react2 = require("@emotion/react");
var _utils = require("../utils");
var _format_selector = require("../../dimension_panel/format_selector");
var _field_select = require("./field_select");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/esql_layer/components/dimension_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function TextBasedDimensionEditor(props) {
  var _props$state$layers$p, _selectedField$meta;
  const [allColumns, setAllColumns] = (0, _react.useState)([]);
  const query = (_props$state$layers$p = props.state.layers[props.layerId]) === null || _props$state$layers$p === void 0 ? void 0 : _props$state$layers$p.query;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    isFullscreen,
    columnId,
    layerId,
    state,
    setState,
    indexPatterns,
    dateRange,
    expressions,
    esqlVariables
  } = props;
  (0, _react.useEffect)(() => {
    // in case the columns are not in the cache, I refetch them
    async function fetchColumns() {
      if (query) {
        const table = await (0, _esqlEditor.fetchFieldsFromESQL)({
          esql: `${query.esql} | limit 0`
        }, expressions, {
          from: dateRange.fromDate,
          to: dateRange.toDate
        }, undefined, Object.values(indexPatterns).length ? Object.values(indexPatterns)[0].timeFieldName : undefined, esqlVariables);
        if (table) {
          var _table$columns;
          const hasNumberTypeColumns = (_table$columns = table.columns) === null || _table$columns === void 0 ? void 0 : _table$columns.some(_utils.isNumeric);
          const columns = table.columns.map(col => {
            var _col$variable, _col$meta, _col$meta2;
            return {
              id: (_col$variable = col.variable) !== null && _col$variable !== void 0 ? _col$variable : col.id,
              name: col.variable ? `??${col.variable}` : col.name,
              meta: (_col$meta = col === null || col === void 0 ? void 0 : col.meta) !== null && _col$meta !== void 0 ? _col$meta : {
                type: 'number'
              },
              variable: col.variable,
              compatible: props.isMetricDimension && hasNumberTypeColumns ? props.filterOperations({
                dataType: col === null || col === void 0 ? void 0 : (_col$meta2 = col.meta) === null || _col$meta2 === void 0 ? void 0 : _col$meta2.type,
                isBucketed: Boolean((0, _utils.isNotNumeric)(col)),
                scale: 'ordinal'
              }) : true
            };
          });
          setAllColumns(columns);
        }
      }
    }
    fetchColumns();
  }, [dateRange.fromDate, dateRange.toDate, expressions, indexPatterns, props, props.expressions, esqlVariables, query]);
  const selectedField = (0, _react.useMemo)(() => {
    const layerColumns = props.state.layers[props.layerId].columns;
    return layerColumns === null || layerColumns === void 0 ? void 0 : layerColumns.find(column => column.columnId === props.columnId);
  }, [props.columnId, props.layerId, props.state.layers]);
  const updateLayer = (0, _react.useCallback)(newLayer => setState(prevState => (0, _utils.mergeLayer)({
    state: prevState,
    layerId,
    newLayer
  })), [layerId, setState]);
  const onFormatChange = (0, _react.useCallback)(newFormat => {
    updateLayer((0, _utils.updateColumnFormat)({
      layer: state.layers[layerId],
      columnId,
      value: newFormat
    }));
  }, [columnId, layerId, state.layers, updateLayer]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "text-based-languages-field-selection-row",
    label: _i18n.i18n.translate('xpack.lens.textBasedLanguages.chooseField', {
      defaultMessage: 'Field'
    }),
    fullWidth: true,
    className: "lnsIndexPatternDimensionEditor--padded",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_field_select.FieldSelect, {
    "data-test-subj": "text-based-dimension-field",
    existingFields: allColumns !== null && allColumns !== void 0 ? allColumns : [],
    selectedField: selectedField,
    onChoose: choice => {
      const column = allColumns === null || allColumns === void 0 ? void 0 : allColumns.find(f => f.name === choice.field);
      const newColumn = {
        columnId: props.columnId,
        fieldName: choice.field,
        meta: column === null || column === void 0 ? void 0 : column.meta,
        variable: column === null || column === void 0 ? void 0 : column.variable,
        label: choice.field
      };
      return props.setState(!selectedField ? {
        ...props.state,
        layers: {
          ...props.state.layers,
          [props.layerId]: {
            ...props.state.layers[props.layerId],
            columns: [...props.state.layers[props.layerId].columns, newColumn]
          }
        }
      } : {
        ...props.state,
        layers: {
          ...props.state.layers,
          [props.layerId]: {
            ...props.state.layers[props.layerId],
            columns: props.state.layers[props.layerId].columns.map(col => col.columnId !== props.columnId ? col : {
              ...col,
              fieldName: choice.field,
              meta: column === null || column === void 0 ? void 0 : column.meta,
              variable: column === null || column === void 0 ? void 0 : column.variable
            })
          }
        }
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  })), props.dataSectionExtra && /*#__PURE__*/_react.default.createElement("div", {
    style: {
      paddingLeft: euiTheme.size.base,
      paddingRight: euiTheme.size.base
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 9
    }
  }, props.dataSectionExtra), !isFullscreen && selectedField && /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsIndexPatternDimensionEditor--padded lnsIndexPatternDimensionEditor--collapseNext",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: (0, _react2.css)`
              margin-bottom: ${euiTheme.size.base};
            `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.lens.indexPattern.dimensionEditor.headingAppearance', {
    defaultMessage: 'Appearance'
  }))), /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.NameInput, {
    value: selectedField.label || '',
    defaultValue: '',
    onChange: value => {
      updateLayer((0, _utils.updateColumnLabel)({
        layer: state.layers[layerId],
        columnId,
        value
      }));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 11
    }
  }), ((_selectedField$meta = selectedField.meta) === null || _selectedField$meta === void 0 ? void 0 : _selectedField$meta.type) === 'number' ? /*#__PURE__*/_react.default.createElement(_format_selector.FormatSelector, {
    selectedColumn: selectedField,
    onChange: onFormatChange,
    docLinks: props.core.docLinks,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 13
    }
  }) : null));
}