"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddESQLPanelAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/ui-actions-plugin/public");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _presentationContainers = require("@kbn/presentation-containers");
var _public2 = require("@kbn/embeddable-plugin/public");
var _esqlUtils = require("@kbn/esql-utils");
var _constants = require("./constants");
var _id_generator = require("../../id_generator");
var _mount = require("../../react_embeddable/mount");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AddESQLPanelAction {
  constructor(core) {
    (0, _defineProperty2.default)(this, "type", _constants.ACTION_CREATE_ESQL_CHART);
    (0, _defineProperty2.default)(this, "id", _constants.ACTION_CREATE_ESQL_CHART);
    (0, _defineProperty2.default)(this, "order", 50);
    (0, _defineProperty2.default)(this, "grouping", [_public2.ADD_PANEL_VISUALIZATION_GROUP]);
    this.core = core;
  }
  getDisplayName() {
    return _i18n.i18n.translate('xpack.lens.app.createVisualizationLabel', {
      defaultMessage: 'ES|QL'
    });
  }
  getIconType() {
    // need to create a new one
    return 'esqlVis';
  }
  async isCompatible({
    embeddable
  }) {
    return (0, _presentationContainers.apiIsPresentationContainer)(embeddable) && this.core.uiSettings.get(_esqlUtils.ENABLE_ESQL);
  }
  async execute({
    embeddable: api
  }) {
    if (!(0, _presentationContainers.apiIsPresentationContainer)(api)) throw new _public.IncompatibleActionError();
    if (!api || !(0, _presentationPublishing.apiHasAppContext)(api)) {
      return;
    }
    const uuid = (0, _id_generator.generateId)();
    (0, _mount.mountInlinePanel)({
      core: this.core,
      api,
      loadContent: async ({
        closeFlyout
      } = {
        closeFlyout: () => {}
      }) => {
        var _embeddable$getEditPa;
        const embeddable = await api.addNewPanel({
          maybePanelId: uuid,
          panelType: 'lens',
          serializedState: {
            rawState: {
              id: uuid,
              isNewPanel: true,
              attributes: {
                references: []
              }
            }
          }
        });
        if (!embeddable) {
          throw new _public.IncompatibleActionError();
        }
        return (_embeddable$getEditPa = embeddable.getEditPanel) === null || _embeddable$getEditPa === void 0 ? void 0 : _embeddable$getEditPa.call(embeddable, {
          closeFlyout,
          showOnly: true
        });
      },
      options: {
        uuid
      }
    });
  }
}
exports.AddESQLPanelAction = AddESQLPanelAction;