"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAxesConfiguration = getAxesConfiguration;
exports.getXDomain = getXDomain;
exports.groupAxesByType = groupAxesByType;
exports.isFormatterCompatible = isFormatterCompatible;
var _shared_components = require("../../shared_components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isFormatterCompatible(formatter1, formatter2) {
  return formatter1.id === formatter2.id;
}
function getXDomain(layers = [], tables) {
  const dataBounds = layers.reduce((bounds, layer) => {
    const tableBounds = (0, _shared_components.getDataBounds)(layer.layerId, tables, layer.xAccessor);
    if (tableBounds) {
      return {
        min: Math.min(bounds.min, tableBounds.min),
        max: Math.max(bounds.max, tableBounds.max)
      };
    }
    return bounds;
  }, {
    min: Infinity,
    max: -Infinity
  });
  if (isFinite(dataBounds.min) && isFinite(dataBounds.max)) {
    return dataBounds;
  }
}
function groupAxesByType(layers, tables) {
  const series = {
    auto: [],
    left: [],
    right: [],
    bottom: []
  };
  layers === null || layers === void 0 ? void 0 : layers.forEach(layer => {
    const table = tables === null || tables === void 0 ? void 0 : tables[layer.layerId];
    layer.accessors.forEach(accessor => {
      var _layer$yConfig, _layer$yConfig$find, _table$columns$find, _table$columns$find$m;
      const mode = ((_layer$yConfig = layer.yConfig) === null || _layer$yConfig === void 0 ? void 0 : (_layer$yConfig$find = _layer$yConfig.find(yAxisConfig => yAxisConfig.forAccessor === accessor)) === null || _layer$yConfig$find === void 0 ? void 0 : _layer$yConfig$find.axisMode) || 'auto';
      let formatter = (table === null || table === void 0 ? void 0 : (_table$columns$find = table.columns.find(column => column.id === accessor)) === null || _table$columns$find === void 0 ? void 0 : (_table$columns$find$m = _table$columns$find.meta) === null || _table$columns$find$m === void 0 ? void 0 : _table$columns$find$m.params) || {
        id: 'number'
      };
      if (layer.seriesType.includes('percentage') && formatter.id !== 'percent') {
        formatter = {
          id: 'percent',
          params: {
            pattern: '0.[00]%'
          }
        };
      }
      series[mode].push({
        layer: layer.layerId,
        accessor,
        fieldFormat: formatter
      });
    });
  });
  series.auto.forEach(currentSeries => {
    if (series.left.length === 0 || tables && series.left.every(leftSeries => isFormatterCompatible(leftSeries.fieldFormat, currentSeries.fieldFormat))) {
      series.left.push(currentSeries);
    } else if (series.right.length === 0 || tables && series.left.every(leftSeries => isFormatterCompatible(leftSeries.fieldFormat, currentSeries.fieldFormat))) {
      series.right.push(currentSeries);
    } else if (series.right.length >= series.left.length) {
      series.left.push(currentSeries);
    } else {
      series.right.push(currentSeries);
    }
  });
  return series;
}
function getAxesConfiguration(layers, shouldRotate, tables, formatFactory) {
  const series = groupAxesByType(layers, tables);
  const axisGroups = [];
  if (series.left.length > 0) {
    axisGroups.push({
      groupId: 'left',
      position: shouldRotate ? 'bottom' : 'left',
      formatter: formatFactory === null || formatFactory === void 0 ? void 0 : formatFactory(series.left[0].fieldFormat),
      series: series.left.map(({
        fieldFormat,
        ...currentSeries
      }) => currentSeries)
    });
  }
  if (series.right.length > 0) {
    axisGroups.push({
      groupId: 'right',
      position: shouldRotate ? 'top' : 'right',
      formatter: formatFactory === null || formatFactory === void 0 ? void 0 : formatFactory(series.right[0].fieldFormat),
      series: series.right.map(({
        fieldFormat,
        ...currentSeries
      }) => currentSeries)
    });
  }
  return axisGroups;
}