"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteExceptionListRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _zodHelpers = require("@kbn/zod-helpers");
var _api = require("@kbn/securitysolution-exceptions-common/api");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteExceptionListRoute = router => {
  router.versioned.delete({
    access: 'public',
    path: _securitysolutionListConstants.EXCEPTION_LIST_URL,
    security: {
      authz: {
        requiredPrivileges: ['lists-all']
      }
    }
  }).addVersion({
    validate: {
      request: {
        query: (0, _zodHelpers.buildRouteValidationWithZod)(_api.DeleteExceptionListRequestQuery)
      }
    },
    version: '2023-10-31'
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const exceptionLists = await (0, _utils.getExceptionListClient)(context);
      const {
        list_id: listId,
        id,
        namespace_type: namespaceType
      } = request.query;
      if (listId == null && id == null) {
        return siemResponse.error({
          body: 'Either "list_id" or "id" needs to be defined in the request',
          statusCode: 400
        });
      }
      const deleted = await exceptionLists.deleteExceptionList({
        id,
        listId,
        namespaceType
      });
      if (deleted == null) {
        return siemResponse.error({
          body: (0, _utils.getErrorMessageExceptionList)({
            id,
            listId
          }),
          statusCode: 404
        });
      }
      return response.ok({
        body: _api.DeleteExceptionListResponse.parse(deleted)
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.deleteExceptionListRoute = deleteExceptionListRoute;