"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogSourcesContext = exports.useLogSources = exports.LogSourcesProvider = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _useTrackedPromise = require("@kbn/use-tracked-promise");
var _react = require("react");
var _utils = require("../../common/services/log_sources_service/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogSources = ({
  logSourcesService
}) => {
  const [logSources, setLogSources] = (0, _react.useState)([]);
  const [logSourcesError, setLogSourcesError] = (0, _react.useState)(undefined);
  const [requestState, getLogSources] = (0, _useTrackedPromise.useTrackedPromise)({
    cancelPreviousOn: 'resolution',
    createPromise: async () => {
      return await logSourcesService.getLogSources();
    },
    onResolve: response => {
      setLogSources(response);
      setLogSourcesError(undefined);
    },
    onReject: response => {
      setLogSourcesError(response);
    }
  }, []);
  (0, _react.useEffect)(() => {
    getLogSources();
  }, [getLogSources]);
  const combinedIndices = (0, _react.useMemo)(() => {
    return (0, _utils.flattenLogSources)(logSources);
  }, [logSources]);
  return {
    isUninitialized: requestState.state === 'uninitialized',
    isLoadingLogSources: requestState.state === 'pending',
    hasFailedLoadingLogSources: logSourcesError !== undefined,
    logSourcesError,
    logSources,
    combinedIndices
  };
};
exports.useLogSources = useLogSources;
const [LogSourcesProvider, useLogSourcesContext] = (0, _constate.default)(useLogSources);
exports.useLogSourcesContext = useLogSourcesContext;
exports.LogSourcesProvider = LogSourcesProvider;